/*
 * Decompiled with CFR 0.152.
 */
package io.github.furstenheim;

import io.github.furstenheim.CodeBlockStyle;
import io.github.furstenheim.CopyNode;
import io.github.furstenheim.HeadingStyle;
import io.github.furstenheim.LinkStyle;
import io.github.furstenheim.NodeUtils;
import io.github.furstenheim.Options;
import io.github.furstenheim.OptionsBuilder;
import io.github.furstenheim.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class CopyDown {
    private Rules rules;
    private final Options options;
    private List<String> references = null;
    private final List<Escape> escapes = Arrays.asList(new Escape("\\\\", "\\\\\\\\"), new Escape("\\*", "\\\\*"), new Escape("^-", "\\\\-"), new Escape("^\\+ ", "\\\\+ "), new Escape("^(=+)", "\\\\$1"), new Escape("^(#{1,6}) ", "\\\\$1 "), new Escape("`", "\\\\`"), new Escape("^~~~", "\\\\~~~"), new Escape("\\[", "\\\\["), new Escape("\\]", "\\\\]"), new Escape("^>", "\\\\>"), new Escape("_", "\\\\_"), new Escape("^(\\d+)\\. ", "$1\\\\. "));
    private static final Pattern leadingNewLinePattern = Pattern.compile("^(\n*)");
    private static final Pattern trailingNewLinePattern = Pattern.compile("(\n*)$");

    public CopyDown() {
        this.options = OptionsBuilder.anOptions().build();
        this.setUp();
    }

    public CopyDown(Options options) {
        this.options = options;
        this.setUp();
    }

    public String convert(String input) {
        this.references = new ArrayList<String>();
        CopyNode copyRootNode = new CopyNode(input);
        String result = this.process(copyRootNode);
        return this.postProcess(result);
    }

    private void setUp() {
        this.rules = new Rules();
    }

    private String postProcess(String output) {
        for (Rule rule : this.rules.rules) {
            if (rule.getAppend() == null) continue;
            output = this.join(output, rule.getAppend().get());
        }
        return output.replaceAll("^[\\t\\n\\r]+", "").replaceAll("[\\t\\r\\n\\s]+$", "");
    }

    private String process(CopyNode node) {
        String result = "";
        for (Node child : node.element.childNodes()) {
            CopyNode copyNodeChild = new CopyNode(child, node);
            String replacement = "";
            if (NodeUtils.isNodeType3(child)) {
                replacement = copyNodeChild.isCode() ? ((TextNode)child).text() : this.escape(((TextNode)child).text());
            } else if (NodeUtils.isNodeType1(child)) {
                replacement = this.replacementForNode(copyNodeChild);
            }
            result = this.join(result, replacement);
        }
        return result;
    }

    private String replacementForNode(CopyNode node) {
        Rule rule = this.rules.findRule(node.element);
        String content = this.process(node);
        CopyNode.FlankingWhiteSpaces flankingWhiteSpaces = node.flankingWhitespace();
        if (flankingWhiteSpaces.getLeading().length() > 0 || flankingWhiteSpaces.getTrailing().length() > 0) {
            content = content.trim();
        }
        return flankingWhiteSpaces.getLeading() + rule.getReplacement().apply(content, node.element) + flankingWhiteSpaces.getTrailing();
    }

    private String join(String string1, String string2) {
        Matcher trailingMatcher = trailingNewLinePattern.matcher(string1);
        trailingMatcher.find();
        Matcher leadingMatcher = leadingNewLinePattern.matcher(string2);
        leadingMatcher.find();
        int nNewLines = Integer.min(2, Integer.max(leadingMatcher.group().length(), trailingMatcher.group().length()));
        String newLineJoin = String.join((CharSequence)"", Collections.nCopies(nNewLines, "\n"));
        return trailingMatcher.replaceAll("") + newLineJoin + leadingMatcher.replaceAll("");
    }

    private String escape(String string) {
        for (Escape escape : this.escapes) {
            string = string.replaceAll(escape.pattern, escape.replace);
        }
        return string;
    }

    class Rules {
        private List<Rule> rules = new ArrayList<Rule>();

        public Rules() {
            this.addRule("blankReplacement", new Rule(element -> CopyNode.isBlank(element), (content, element) -> CopyNode.isBlock(element) ? "\n\n" : ""));
            this.addRule("paragraph", new Rule("p", (content, element) -> "\n\n" + content + "\n\n"));
            this.addRule("br", new Rule("br", (content, element) -> ((CopyDown)CopyDown.this).options.br + "\n"));
            this.addRule("heading", new Rule(new String[]{"h1", "h2", "h3", "h4", "h5", "h6"}, (content, element) -> {
                Integer hLevel = Integer.parseInt(element.nodeName().substring(1, 2));
                if (((CopyDown)CopyDown.this).options.headingStyle == HeadingStyle.SETEXT && hLevel < 3) {
                    String underline = String.join((CharSequence)"", Collections.nCopies(content.length(), hLevel == 1 ? "=" : "-"));
                    return "\n\n" + content + "\n" + underline + "\n\n";
                }
                return "\n\n" + String.join((CharSequence)"", Collections.nCopies(hLevel, "#")) + " " + content + "\n\n";
            }));
            this.addRule("blockquote", new Rule("blockquote", (content, element) -> {
                content = content.replaceAll("^\n+|\n+$", "");
                content = content.replaceAll("(?m)^", "> ");
                return "\n\n" + content + "\n\n";
            }));
            this.addRule("list", new Rule(new String[]{"ul", "ol"}, (content, element) -> {
                Element parent = (Element)element.parentNode();
                if (parent.nodeName().equals("li") && parent.child(parent.childrenSize() - 1) == element) {
                    return "\n" + content;
                }
                return "\n\n" + content + "\n\n";
            }));
            this.addRule("listItem", new Rule("li", (content, element) -> {
                content = content.replaceAll("^\n+", "").replaceAll("\n+$", "\n").replaceAll("(?m)\n", "\n    ");
                String prefix = ((CopyDown)CopyDown.this).options.bulletListMaker + "   ";
                Element parent = (Element)element.parentNode();
                if (parent.nodeName().equals("ol")) {
                    String start = parent.attr("start");
                    int index = parent.children().indexOf(element);
                    int parsedStart = 1;
                    if (start.length() != 0) {
                        try {
                            parsedStart = Integer.valueOf(start);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    prefix = String.valueOf(parsedStart + index) + ".  ";
                }
                return prefix + content + (element.nextSibling() != null && !Pattern.compile("\n$").matcher((CharSequence)content).find() ? "\n" : "");
            }));
            this.addRule("indentedCodeBlock", new Rule(element -> ((CopyDown)CopyDown.this).options.codeBlockStyle == CodeBlockStyle.INDENTED && element.nodeName().equals("pre") && element.childNodeSize() > 0 && element.childNode(0).nodeName().equals("code"), (content, element) -> "\n\n    " + ((Element)element.childNode(0)).wholeText().replaceAll("\n", "\n    ")));
            this.addRule("fencedCodeBock", new Rule(element -> ((CopyDown)CopyDown.this).options.codeBlockStyle == CodeBlockStyle.FENCED && element.nodeName().equals("pre") && element.childNodeSize() > 0 && element.childNode(0).nodeName().equals("code"), (content, element) -> {
                String childClass = element.childNode(0).attr("class");
                if (childClass == null) {
                    childClass = "";
                }
                Matcher languageMatcher = Pattern.compile("language-(\\S+)").matcher(childClass);
                String language = "";
                if (languageMatcher.find()) {
                    language = languageMatcher.group(1);
                }
                String code = element.childNode(0) instanceof Element ? ((Element)element.childNode(0)).wholeText() : element.childNode(0).outerHtml();
                String fenceChar = ((CopyDown)CopyDown.this).options.fence.substring(0, 1);
                int fenceSize = 3;
                Matcher fenceMatcher = Pattern.compile("(?m)^(" + fenceChar + "{3,})").matcher((CharSequence)content);
                while (fenceMatcher.find()) {
                    String group = fenceMatcher.group(1);
                    fenceSize = Math.max(group.length() + 1, fenceSize);
                }
                String fence = String.join((CharSequence)"", Collections.nCopies(fenceSize, fenceChar));
                if (code.length() > 0 && code.charAt(code.length() - 1) == '\n') {
                    code = code.substring(0, code.length() - 1);
                }
                return "\n\n" + fence + language + "\n" + code + "\n" + fence + "\n\n";
            }));
            this.addRule("horizontalRule", new Rule("hr", (content, element) -> "\n\n" + ((CopyDown)CopyDown.this).options.hr + "\n\n"));
            this.addRule("inlineLink", new Rule(element -> ((CopyDown)CopyDown.this).options.linkStyle == LinkStyle.INLINED && element.nodeName().equals("a") && element.attr("href").length() != 0, (content, element) -> {
                String href = element.attr("href");
                String title = this.cleanAttribute(element.attr("title"));
                if (title.length() != 0) {
                    title = " \"" + title + "\"";
                }
                return "[" + content + "](" + href + title + ")";
            }));
            this.addRule("referenceLink", new Rule(element -> ((CopyDown)CopyDown.this).options.linkStyle == LinkStyle.REFERENCED && element.nodeName().equals("a") && element.attr("href").length() != 0, (content, element) -> {
                String reference;
                String replacement;
                String href = element.attr("href");
                String title = this.cleanAttribute(element.attr("title"));
                if (title.length() != 0) {
                    title = " \"" + title + "\"";
                }
                switch (((CopyDown)CopyDown.this).options.linkReferenceStyle) {
                    case COLLAPSED: {
                        replacement = "[" + content + "][]";
                        reference = "[" + content + "]: " + href + title;
                        break;
                    }
                    case SHORTCUT: {
                        replacement = "[" + content + "]";
                        reference = "[" + content + "]: " + href + title;
                        break;
                    }
                    default: {
                        int id = CopyDown.this.references.size() + 1;
                        replacement = "[" + content + "][" + id + "]";
                        reference = "[" + id + "]: " + href + title;
                    }
                }
                CopyDown.this.references.add(reference);
                return replacement;
            }, () -> {
                String referenceString = "";
                if (CopyDown.this.references.size() > 0) {
                    referenceString = "\n\n" + String.join((CharSequence)"\n", CopyDown.this.references) + "\n\n";
                }
                return referenceString;
            }));
            this.addRule("emphasis", new Rule(new String[]{"em", "i"}, (content, element) -> {
                if (content.trim().length() == 0) {
                    return "";
                }
                return ((CopyDown)CopyDown.this).options.emDelimiter + content + ((CopyDown)CopyDown.this).options.emDelimiter;
            }));
            this.addRule("strong", new Rule(new String[]{"strong", "b"}, (content, element) -> {
                if (content.trim().length() == 0) {
                    return "";
                }
                return ((CopyDown)CopyDown.this).options.strongDelimiter + content + ((CopyDown)CopyDown.this).options.strongDelimiter;
            }));
            this.addRule("code", new Rule(element -> {
                boolean hasSiblings = element.previousSibling() != null || element.nextSibling() != null;
                boolean isCodeBlock = element.parentNode().nodeName().equals("pre") && !hasSiblings;
                return element.nodeName().equals("code") && !isCodeBlock;
            }, (content, element) -> {
                if (content.trim().length() == 0) {
                    return "";
                }
                String delimiter = "`";
                String leadingSpace = "";
                String trailingSpace = "";
                Pattern pattern = Pattern.compile("(?m)(`)+");
                Matcher matcher = pattern.matcher((CharSequence)content);
                if (matcher.find()) {
                    if (Pattern.compile("^`").matcher((CharSequence)content).find()) {
                        leadingSpace = " ";
                    }
                    if (Pattern.compile("`$").matcher((CharSequence)content).find()) {
                        trailingSpace = " ";
                    }
                    int counter = 1;
                    if (delimiter.equals(matcher.group())) {
                        ++counter;
                    }
                    while (matcher.find()) {
                        if (!delimiter.equals(matcher.group())) continue;
                        ++counter;
                    }
                    delimiter = String.join((CharSequence)"", Collections.nCopies(counter, "`"));
                }
                return delimiter + leadingSpace + content + trailingSpace + delimiter;
            }));
            this.addRule("img", new Rule("img", (content, element) -> {
                String alt = this.cleanAttribute(element.attr("alt"));
                String src = element.attr("src");
                if (src.length() == 0) {
                    return "";
                }
                String title = this.cleanAttribute(element.attr("title"));
                String titlePart = "";
                if (title.length() != 0) {
                    titlePart = " \"" + title + "\"";
                }
                return "![" + alt + "](" + src + titlePart + ")";
            }));
            this.addRule("default", new Rule(element -> true, (content, element) -> CopyNode.isBlock(element) ? "\n\n" + content + "\n\n" : content));
        }

        public Rule findRule(Node node) {
            for (Rule rule : this.rules) {
                if (!rule.getFilter().test(node)) continue;
                return rule;
            }
            return null;
        }

        private void addRule(String name, Rule rule) {
            rule.setName(name);
            this.rules.add(rule);
        }

        private String cleanAttribute(String attribute) {
            return attribute.replaceAll("(\n+\\s*)+", "\n");
        }
    }

    private static class Escape {
        String pattern;
        String replace;

        public Escape(String pattern, String replace) {
            this.pattern = pattern;
            this.replace = replace;
        }
    }
}

