/*
 * Decompiled with CFR 0.152.
 */
package io.github.furstenheim;

import io.github.furstenheim.NodeUtils;
import io.github.furstenheim.WhitespaceCollapser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

class CopyNode {
    private static final String[] VOID_ELEMENTS = new String[]{"area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"};
    private static final String[] MEANINGFUL_WHEN_BLANK_ELEMENTS = new String[]{"a", "table", "thead", "tbody", "tfoot", "th", "td", "iframe", "script", "audio", "video"};
    private static final String[] BLOCK_ELEMENTS = new String[]{"address", "article", "aside", "audio", "blockquote", "body", "canvas", "center", "dd", "dir", "div", "dl", "dt", "fieldset", "figcaption", "figure", "footer", "form", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hgroup", "hr", "html", "isindex", "li", "main", "menu", "nav", "noframes", "noscript", "ol", "output", "p", "pre", "section", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "ul"};
    private static Set<String> VOID_ELEMENTS_SET = null;
    private static Set<String> MEANINGFUL_WHEN_BLANK_ELEMENTS_SET = null;
    private static Set<String> BLOCK_ELEMENTS_SET = null;
    Node element;
    CopyNode parent;

    CopyNode(String input) {
        Document document = Jsoup.parse((String)("<x-copydown id=\"copydown-root\">" + input + "</x-copydown>"));
        Element root = document.getElementById("copydown-root");
        new WhitespaceCollapser().collapse((Node)root);
        this.element = root;
    }

    CopyNode(Node node, CopyNode parent) {
        this.element = node;
        this.parent = parent;
    }

    boolean isCode() {
        return this.element.nodeName().equals("code") || this.parent != null && this.parent.isCode();
    }

    static boolean isBlank(Node element) {
        String textContent = element instanceof Element ? ((Element)element).wholeText() : element.outerHtml();
        return !CopyNode.isVoid(element) && !CopyNode.isMeaningfulWhenBlank(element) && Pattern.compile("(?i)^\\s*$").matcher(textContent).find() && !CopyNode.hasVoidNodesSet(element) && !CopyNode.hasMeaningfulWhenBlankNodesSet(element);
    }

    FlankingWhiteSpaces flankingWhitespace() {
        String leading = "";
        String trailing = "";
        if (!CopyNode.isBlock(this.element)) {
            boolean blankWithSpaces;
            String textContent = this.element instanceof Element ? ((Element)this.element).wholeText() : this.element.outerHtml();
            boolean hasLeading = Pattern.compile("^\\s").matcher(textContent).find();
            boolean hasTrailing = Pattern.compile("\\s$").matcher(textContent).find();
            boolean bl = blankWithSpaces = CopyNode.isBlank(this.element) && hasLeading && hasTrailing;
            if (hasLeading && !this.isLeftFlankedByWhitespaces()) {
                leading = " ";
            }
            if (!blankWithSpaces && hasTrailing && !this.isRightFlankedByWhitespaces()) {
                trailing = " ";
            }
        }
        return new FlankingWhiteSpaces(leading, trailing);
    }

    private boolean isLeftFlankedByWhitespaces() {
        return this.isChildFlankedByWhitespaces(" $", this.element.previousSibling());
    }

    private boolean isRightFlankedByWhitespaces() {
        return this.isChildFlankedByWhitespaces("^ ", this.element.nextSibling());
    }

    private boolean isChildFlankedByWhitespaces(String regex, Node sibling) {
        if (sibling == null) {
            return false;
        }
        if (NodeUtils.isNodeType3(sibling)) {
            return Pattern.compile(regex).matcher(sibling.outerHtml()).find();
        }
        if (NodeUtils.isNodeType1(sibling)) {
            return Pattern.compile(regex).matcher(sibling.outerHtml()).find();
        }
        return false;
    }

    private static boolean hasVoidNodesSet(Node node) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        for (String tagName : VOID_ELEMENTS_SET) {
            if (element.getElementsByTag(tagName).size() == 0) continue;
            return true;
        }
        return false;
    }

    static boolean isVoid(Node element) {
        return CopyNode.getVoidNodesSet().contains(element.nodeName());
    }

    private static Set<String> getVoidNodesSet() {
        if (VOID_ELEMENTS_SET != null) {
            return VOID_ELEMENTS_SET;
        }
        VOID_ELEMENTS_SET = new HashSet<String>(Arrays.asList(VOID_ELEMENTS));
        return VOID_ELEMENTS_SET;
    }

    private static boolean hasMeaningfulWhenBlankNodesSet(Node node) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        for (String tagName : MEANINGFUL_WHEN_BLANK_ELEMENTS_SET) {
            if (element.getElementsByTag(tagName).size() == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean isMeaningfulWhenBlank(Node element) {
        return CopyNode.getMeaningfulWhenBlankNodesSet().contains(element.nodeName());
    }

    private static Set<String> getMeaningfulWhenBlankNodesSet() {
        if (MEANINGFUL_WHEN_BLANK_ELEMENTS_SET != null) {
            return MEANINGFUL_WHEN_BLANK_ELEMENTS_SET;
        }
        MEANINGFUL_WHEN_BLANK_ELEMENTS_SET = new HashSet<String>(Arrays.asList(MEANINGFUL_WHEN_BLANK_ELEMENTS));
        return MEANINGFUL_WHEN_BLANK_ELEMENTS_SET;
    }

    private boolean hasBlockNodesSet(Node node) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        for (String tagName : BLOCK_ELEMENTS_SET) {
            if (element.getElementsByTag(tagName).size() == 0) continue;
            return true;
        }
        return false;
    }

    static boolean isBlock(Node element) {
        return CopyNode.getBlockNodesSet().contains(element.nodeName());
    }

    private static Set<String> getBlockNodesSet() {
        if (BLOCK_ELEMENTS_SET != null) {
            return BLOCK_ELEMENTS_SET;
        }
        BLOCK_ELEMENTS_SET = new HashSet<String>(Arrays.asList(BLOCK_ELEMENTS));
        return BLOCK_ELEMENTS_SET;
    }

    static class FlankingWhiteSpaces {
        private final String leading;
        private final String trailing;

        String getLeading() {
            return this.leading;
        }

        String getTrailing() {
            return this.trailing;
        }

        FlankingWhiteSpaces(String leading, String trailing) {
            this.leading = leading;
            this.trailing = trailing;
        }
    }
}

