/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.model.WindowsConfig;
import io.github.fvarrui.javapackager.packagers.AbstractCreateWindowsExe;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.JarUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class CreateWindowsExeWinRun4j
extends AbstractCreateWindowsExe {
    private static final String[] JVM_DLL_PATHS = new String[]{"bin/client/jvm.dll", "bin/server/jvm.dll"};

    public CreateWindowsExeWinRun4j() {
        super("winrun4j");
    }

    @Override
    public boolean skip(WindowsPackager packager) {
        if (!packager.getPlatform().isCurrentPlatform()) {
            Logger.error(this.getArtifactName() + " cannot be generated with WinRun4J due to the target platform (" + (Object)((Object)packager.getPlatform()) + ") is different from the execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + ")!");
            return true;
        }
        return false;
    }

    @Override
    protected File doApply(WindowsPackager packager) throws Exception {
        String name = packager.getName();
        File executable = packager.getExecutable();
        File jarFile = packager.getJarFile();
        File manifestFile = packager.getManifestFile();
        File iconFile = packager.getIconFile();
        File libsFolder = packager.getLibsFolder();
        File appFolder = packager.getAppFolder();
        String mainClass = packager.getMainClass();
        File jreDestinationFolder = packager.getJreDestinationFolder();
        boolean bundleJre = packager.getBundleJre();
        String vmLocation = packager.getWinConfig().getVmLocation();
        WindowsConfig winConfig = packager.getWinConfig();
        if (winConfig.isWrapJar()) {
            Logger.warn("'wrapJar' property ignored when building EXE with " + this.getArtifactName());
        }
        this.createAssets(packager);
        FileUtils.copyFileToFile(manifestFile, this.getGenericManifest());
        FileUtils.copyFileToFile(iconFile, this.getGenericIcon());
        FileUtils.copyResourceToFile("/windows/WinRun4J64.exe", this.getGenericExe());
        File rcedit = new File(this.getOutputFolder(), "rcedit.exe");
        FileUtils.copyResourceToFile("/windows/rcedit-x64.exe", rcedit);
        if (bundleJre) {
            if (!StringUtils.isBlank((CharSequence)vmLocation)) {
                if (!new File(jreDestinationFolder, vmLocation).exists()) {
                    throw new Exception("VM location '" + vmLocation + "' does not exist");
                }
                vmLocation = vmLocation.replaceAll("/", "\\\\");
            } else {
                Optional<File> jvmDllFile = Arrays.asList(JVM_DLL_PATHS).stream().map(path -> new File(jreDestinationFolder, (String)path)).filter(file -> file.exists()).findFirst();
                if (!jvmDllFile.isPresent()) {
                    throw new Exception("jvm.dll not found!");
                }
                Path jreDestinationPath = jreDestinationFolder.toPath();
                Path jvmDllPath = jvmDllFile.get().toPath();
                vmLocation = jreDestinationPath.relativize(jvmDllPath).toString();
            }
            packager.getWinConfig().setVmLocation(vmLocation);
            Logger.info("Using 'vmLocation=" + vmLocation + "'!");
        }
        File genericIni = new File(this.getOutputFolder(), "app.ini");
        VelocityUtils.render("windows/ini.vtl", genericIni, packager);
        Logger.info("INI file generated in " + genericIni.getAbsolutePath() + "!");
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-icon", this.getGenericIcon());
        CommandUtils.execute(rcedit, this.getGenericExe(), "--application-manifest", this.getGenericManifest());
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-version-string", "FileDescription", name);
        FileUtils.copyFileToFolder(jarFile, appFolder);
        File winrun4jJar = new File(libsFolder, "winrun4j-launcher.jar");
        FileUtils.copyResourceToFile("/windows/winrun4j-launcher.jar", winrun4jJar);
        File propertiesFile = new File(this.getOutputFolder(), "winrun4j.properties");
        Properties properties = new Properties();
        properties.setProperty("main.class", mainClass);
        properties.store(new FileOutputStream(propertiesFile), "WinRun4J Helper Launcher Properties");
        JarUtils.addFileToJar(winrun4jJar, propertiesFile);
        File iniFile = new File(appFolder, name + ".ini");
        FileUtils.copyFileToFile(genericIni, iniFile);
        this.sign(this.getGenericExe(), packager);
        FileUtils.copyFileToFile(this.getGenericExe(), executable);
        return this.createBootstrapScript(packager);
    }
}

