/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.MacPackager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import java.io.File;

public class GeneratePkg
extends ArtifactGenerator<MacPackager> {
    public GeneratePkg() {
        super("PKG installer");
    }

    @Override
    public boolean skip(MacPackager packager) {
        if (!packager.getMacConfig().isGeneratePkg()) {
            return true;
        }
        if (!packager.getPlatform().isCurrentPlatform() && !packager.isForceInstaller()) {
            Logger.warn(this.getArtifactName() + " cannot be generated due to the target platform (" + (Object)((Object)packager.getPlatform()) + ") is different from the execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + ")!");
            return true;
        }
        return false;
    }

    @Override
    protected File doApply(MacPackager packager) throws Exception {
        File appFile = packager.getAppFile();
        String name = packager.getName();
        File outputDirectory = packager.getOutputDirectory();
        String version = packager.getVersion();
        File pkgFile = new File(outputDirectory, name + "_" + version + ".pkg");
        CommandUtils.execute("pkgbuild", "--install-location", "/Applications", "--component", appFile, pkgFile);
        if (!pkgFile.exists()) {
            throw new Exception(this.getArtifactName() + " generation failed!");
        }
        return pkgFile;
    }
}

