/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.LinuxPackager;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.redline_rpm.Builder;
import org.redline_rpm.header.Architecture;
import org.redline_rpm.header.Os;
import org.redline_rpm.header.RpmType;

public class GenerateRpm
extends ArtifactGenerator<LinuxPackager> {
    public GenerateRpm() {
        super("RPM package");
    }

    @Override
    public boolean skip(LinuxPackager packager) {
        return !packager.getLinuxConfig().isGenerateRpm();
    }

    @Override
    protected File doApply(LinuxPackager packager) throws Exception {
        File appFolder = packager.getAppFolder();
        String name = packager.getName();
        String version = packager.getVersion().replaceAll("-", "_");
        String description = packager.getDescription();
        String organizationName = packager.getOrganizationName();
        File outputDirectory = packager.getOutputDirectory();
        File executable = packager.getExecutable();
        File assetsFolder = packager.getAssetsFolder();
        String jreDirectoryName = packager.getJreDirectoryName();
        File desktopFile = new File(assetsFolder, name + ".desktop");
        VelocityUtils.render("linux/desktop.vtl", desktopFile, packager);
        Logger.info("Rendering desktop file to " + desktopFile.getAbsolutePath());
        FileUtils.copyFileToFolder(desktopFile, appFolder);
        Builder builder = new Builder();
        builder.setType(RpmType.BINARY);
        builder.setPlatform(Architecture.X86_64, Os.LINUX);
        builder.setPackage((CharSequence)name, (CharSequence)version, (CharSequence)"1");
        builder.setPackager((CharSequence)organizationName);
        builder.setDescription((CharSequence)description);
        builder.setPrefixes(new String[]{"opt"});
        ArrayList<File> executionPermissions = new ArrayList<File>();
        executionPermissions.add(executable);
        executionPermissions.add(new File(appFolder, jreDirectoryName + "/bin/java"));
        executionPermissions.add(new File(appFolder, jreDirectoryName + "/lib/jspawnhelper"));
        this.addDirectoryTree(builder, "/opt", appFolder, executionPermissions);
        builder.addLink("/usr/share/applications/" + desktopFile.getName(), "/opt/" + name + "/" + desktopFile.getName());
        builder.addLink("/usr/local/bin/" + executable.getName(), "/opt/" + name + "/" + executable.getName());
        builder.build(outputDirectory);
        File originalRpm = new File(outputDirectory, name + "-" + version + "-1.x86_64.rpm");
        File rpm = null;
        if (originalRpm.exists()) {
            rpm = new File(outputDirectory, name + "_" + version + ".rpm");
            if (rpm.exists()) {
                rpm.delete();
            }
            FileUtils.rename(originalRpm, rpm.getName());
        }
        return rpm;
    }

    private void addDirectoryTree(Builder builder, String parentPath, File root, List<File> executionPermissions) throws NoSuchAlgorithmException, IOException {
        String rootPath = parentPath + "/" + root.getName();
        builder.addDirectory(rootPath);
        for (File f : root.listFiles()) {
            if (f.isDirectory()) {
                this.addDirectoryTree(builder, parentPath + "/" + root.getName(), f, executionPermissions);
                continue;
            }
            builder.addFile(rootPath + "/" + f.getName(), f, executionPermissions.contains(f) ? 493 : 420);
        }
    }
}

