/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.utils;

import io.github.fvarrui.javapackager.utils.Commandline;
import io.github.fvarrui.javapackager.utils.ExecutionResult;
import io.github.fvarrui.javapackager.utils.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

public class CommandUtils {
    public static String executeOnDirectory(File workingDirectory, String executable, Object ... arguments) throws IOException, CommandLineException {
        ExecutionResult result = CommandUtils.executeWithResult(workingDirectory, executable, arguments);
        if (result.getExitCode() != 0) {
            throw new CommandLineException("Command execution failed: " + executable + " " + StringUtils.join((Object[])arguments, (String)" "));
        }
        return result.getOutput();
    }

    public static String execute(File executable, Object ... arguments) throws IOException, CommandLineException {
        return CommandUtils.execute(executable.getAbsolutePath(), arguments);
    }

    public static String execute(String executable, Object ... arguments) throws IOException, CommandLineException {
        return CommandUtils.executeOnDirectory(new File("."), executable, arguments);
    }

    public static ExecutionResult executeWithResult(File workingDirectory, String executable, Object ... arguments) throws IOException, CommandLineException {
        ExecutionResult result = new ExecutionResult();
        StringBuffer outputBuffer = new StringBuffer();
        StringBuffer errorBuffer = new StringBuffer();
        Commandline command = new Commandline();
        command.setWorkingDirectory(workingDirectory);
        command.setExecutable(executable);
        command.createArguments(arguments);
        command.toString();
        String commandLine = command.getCommandLineAsString();
        Logger.info("Executing command: " + commandLine);
        Process process = command.execute();
        BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while (process.isAlive() || output.ready() || error.ready()) {
            if (output.ready()) {
                String outputLine = output.readLine();
                Logger.info(outputLine);
                outputBuffer.append(outputLine + "\n");
            }
            if (!error.ready()) continue;
            String errorLine = error.readLine();
            Logger.error(errorLine);
            errorBuffer.append(errorLine + "\n");
        }
        output.close();
        error.close();
        result.setCommandLine(commandLine);
        result.setOutput(outputBuffer.toString());
        result.setError(errorBuffer.toString());
        result.setExitCode(process.exitValue());
        return result;
    }
}

