/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.model.WindowsConfig;
import io.github.fvarrui.javapackager.model.WindowsExeCreationTool;
import io.github.fvarrui.javapackager.packagers.AbstractCreateWindowsExe;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;

public class CreateWindowsExeWhy
extends AbstractCreateWindowsExe {
    public CreateWindowsExeWhy() {
        super(WindowsExeCreationTool.why);
    }

    @Override
    public boolean skip(WindowsPackager packager) {
        if (!packager.getPlatform().isCurrentPlatform()) {
            Logger.error(this.getArtifactName() + " cannot be generated with Why due to the target platform (" + (Object)((Object)packager.getPlatform()) + ") is different from the execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + ")!");
            return true;
        }
        return false;
    }

    @Override
    protected File doApply(WindowsPackager packager) throws Exception {
        String name = packager.getName();
        File executable = packager.getExecutable();
        File manifestFile = packager.getManifestFile();
        File iconFile = packager.getIconFile();
        File appFolder = packager.getAppFolder();
        File jarFile = packager.getJarFile();
        WindowsConfig winConfig = packager.getWinConfig();
        if (winConfig.isWrapJar()) {
            Logger.warn("'wrapJar' property ignored when building EXE with " + this.getArtifactName());
        }
        this.createAssets(packager);
        FileUtils.copyFileToFile(manifestFile, this.getGenericManifest());
        FileUtils.copyFileToFile(iconFile, this.getGenericIcon());
        FileUtils.copyResourceToFile("/windows/JavaLauncher.exe", this.getGenericExe(), packager.getAssetsDir());
        File rcedit = new File(this.getOutputFolder(), "rcedit.exe");
        FileUtils.copyResourceToFile("/windows/rcedit-x64.exe", rcedit);
        File genericIni = new File(this.getOutputFolder(), "launcher.ini");
        VelocityUtils.render("windows/why-ini.vtl", genericIni, packager);
        Logger.info("INI file generated in " + genericIni.getAbsolutePath() + "!");
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-icon", this.getGenericIcon());
        CommandUtils.execute(rcedit, this.getGenericExe(), "--application-manifest", this.getGenericManifest());
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-version-string", "FileDescription", name);
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-file-version", winConfig.getFileVersion());
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-product-version", winConfig.getProductVersion());
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-version-string", "CompanyName", winConfig.getCompanyName());
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-version-string", "InternalName", winConfig.getInternalName());
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-version-string", "OriginalFilename", winConfig.getOriginalFilename());
        CommandUtils.execute(rcedit, this.getGenericExe(), "--set-version-string", "ProductName", winConfig.getProductName());
        FileUtils.copyFileToFolder(jarFile, appFolder);
        FileUtils.copyFileToFolder(genericIni, appFolder);
        this.sign(this.getGenericExe(), packager);
        FileUtils.copyFileToFile(this.getGenericExe(), executable);
        return this.createBootstrapScript(packager);
    }
}

