/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.LinuxPackager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;

public class GenerateAppImage
extends ArtifactGenerator<LinuxPackager> {
    private static final int IMAGETOOL_VERSION = 13;
    private static final String IMAGETOOL_URL = "https://github.com/AppImage/AppImageKit/releases/download/13/appimagetool-%s.AppImage";

    public GenerateAppImage() {
        super("AppImage");
    }

    @Override
    public boolean skip(LinuxPackager packager) {
        if (!packager.getLinuxConfig().isGenerateAppImage()) {
            return true;
        }
        if (!packager.getPlatform().isCurrentPlatform() && !packager.isForceInstaller()) {
            Logger.warn(this.getArtifactName() + " cannot be generated due to the target platform (" + (Object)((Object)packager.getPlatform()) + ") is different from the execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + ")!");
            return true;
        }
        return false;
    }

    @Override
    protected File doApply(LinuxPackager packager) throws Exception {
        File appFolder = packager.getAppFolder();
        File outputFolder = packager.getOutputDirectory();
        String name = packager.getName();
        File executable = packager.getExecutable();
        File assetsFolder = packager.getAssetsFolder();
        File iconFile = packager.getIconFile();
        File appImage = new File(outputFolder, name + ".AppImage");
        File appDir = new File(assetsFolder, "AppDir");
        Logger.info("Getting appimagetool...");
        File appImageTool = this.getAppImageTool(packager);
        Logger.info("App image tool found! " + appImageTool);
        FileUtils.copyFolderContentToFolder(appFolder, new File(appDir, "usr/bin"));
        File desktopFile = new File(appDir, name + ".desktop");
        VelocityUtils.render("linux/desktop-appimage.vtl", desktopFile, packager);
        Logger.info("Desktop file rendered in " + desktopFile.getAbsolutePath());
        Logger.info("Creating AppRun symlink to startup script...");
        File appRun = new File(appDir, "AppRun");
        FileUtils.createSymlink(appRun, new File("usr/bin", executable.getName()));
        Logger.info("Copying icon to AppDir ...");
        FileUtils.copyFileToFolder(iconFile, appDir);
        Logger.info("Running appimagetool on " + appFolder);
        CommandUtils.execute(appImageTool, "--appimage-extract-and-run", appDir, appImage);
        Logger.info("Setting execution permissions to " + appImage);
        appImage.setExecutable(true);
        return appImage;
    }

    private File getAppImageTool(LinuxPackager packager) throws Exception {
        File assetsFolder = packager.getAssetsFolder();
        File appImageTool = new File(assetsFolder, "appimagetool");
        if (!appImageTool.exists()) {
            String imageToolUrl = String.format(IMAGETOOL_URL, this.getOSArch());
            try {
                FileUtils.downloadFromUrl(imageToolUrl, appImageTool);
            }
            catch (IOException e) {
                throw new Exception(imageToolUrl + "not found! ... Unsupported OS architecture " + this.getOSArch() + "?");
            }
            appImageTool.setExecutable(true);
        }
        return appImageTool;
    }

    private String getOSArch() {
        switch (SystemUtils.OS_ARCH) {
            case "amd64": {
                return "x86_64";
            }
            case "x86": 
            case "i386": {
                return "i686";
            }
        }
        return SystemUtils.OS_ARCH;
    }
}

