/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.utils;

import io.github.fvarrui.javapackager.packagers.Context;
import org.apache.commons.lang3.StringUtils;

public class Logger {
    private static final String TAB = "    ";
    private static int tabs = 0;

    public static String error(String error) {
        if (Context.isMaven()) {
            Context.getMavenContext().getLogger().error((CharSequence)(StringUtils.repeat((String)TAB, (int)tabs) + error));
        }
        if (Context.isGradle()) {
            Context.getGradleContext().getLogger().error(StringUtils.repeat((String)TAB, (int)tabs) + error);
        }
        return error;
    }

    public static String error(String error, Throwable t) {
        if (Context.isMaven()) {
            Context.getMavenContext().getLogger().error((CharSequence)(StringUtils.repeat((String)TAB, (int)tabs) + error));
            Context.getMavenContext().getLogger().error(t);
        }
        if (Context.isGradle()) {
            Context.getGradleContext().getLogger().error(StringUtils.repeat((String)TAB, (int)tabs) + error, t);
        }
        return error;
    }

    public static String warn(String warn) {
        if (Context.isMaven()) {
            Context.getMavenContext().getLogger().warn((CharSequence)(StringUtils.repeat((String)TAB, (int)tabs) + warn));
        }
        if (Context.isGradle()) {
            Context.getGradleContext().getLogger().warn(StringUtils.repeat((String)TAB, (int)tabs) + warn);
        }
        return warn;
    }

    public static String info(String info) {
        if (Context.isMaven()) {
            Context.getMavenContext().getLogger().info((CharSequence)(StringUtils.repeat((String)TAB, (int)tabs) + info));
        }
        if (Context.isGradle()) {
            Context.getGradleContext().getLogger().quiet(StringUtils.repeat((String)TAB, (int)tabs) + info);
        }
        return info;
    }

    public static String debug(String debug) {
        if (Context.isMaven()) {
            Context.getMavenContext().getLogger().debug((CharSequence)(StringUtils.repeat((String)TAB, (int)tabs) + debug));
        }
        if (Context.isGradle()) {
            Context.getGradleContext().getLogger().debug(StringUtils.repeat((String)TAB, (int)tabs) + debug);
        }
        return debug;
    }

    public static void infoIndent(String msg) {
        Logger.info(msg);
        ++tabs;
    }

    public static void infoUnindent(String msg) {
        --tabs;
        Logger.info(msg);
        Logger.info("");
    }

    public static void warnUnindent(String msg) {
        --tabs;
        Logger.warn(msg);
        Logger.info("");
    }

    public static void errorUnindent(String msg) {
        --tabs;
        Logger.error(msg);
        Logger.info("");
    }

    public static void errorUnindent(String msg, Throwable t) {
        --tabs;
        Logger.error(msg, t);
        Logger.info("");
    }
}

