/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.gradle;

import edu.sc.seis.launch4j.tasks.Launch4jLibraryTask;
import io.github.fvarrui.javapackager.model.WindowsConfig;
import io.github.fvarrui.javapackager.model.WindowsExeCreationTool;
import io.github.fvarrui.javapackager.packagers.AbstractCreateWindowsExe;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.FileUtils;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CreateWindowsExeLaunch4j
extends AbstractCreateWindowsExe {
    public CreateWindowsExeLaunch4j() {
        super(WindowsExeCreationTool.launch4j);
    }

    @Override
    protected File doApply(WindowsPackager packager) throws Exception {
        String jarPath;
        List<String> vmArgs = packager.getVmArgs();
        WindowsConfig winConfig = packager.getWinConfig();
        File executable = packager.getExecutable();
        String mainClass = packager.getMainClass();
        boolean useResourcesAsWorkingDir = packager.isUseResourcesAsWorkingDir();
        boolean bundleJre = packager.getBundleJre();
        String jreDirectoryName = packager.getJreDirectoryName();
        String jreMinVersion = packager.getJreMinVersion();
        File jarFile = packager.getJarFile();
        File appFolder = packager.getAppFolder();
        this.createAssets(packager);
        if (winConfig.isWrapJar()) {
            jarPath = this.getGenericJar().getAbsolutePath();
        } else {
            FileUtils.copyFileToFolder(jarFile, appFolder);
            jarPath = jarFile.getName();
        }
        Launch4jLibraryTask l4jTask = Context.getGradleContext().getLibraryTask();
        l4jTask.getOutputs().upToDateWhen(task -> false);
        l4jTask.setHeaderType(winConfig.getHeaderType().toString());
        l4jTask.setJar(jarPath);
        l4jTask.setDontWrapJar(Boolean.valueOf(!winConfig.isWrapJar()));
        l4jTask.setOutfile(this.getGenericExe().getName());
        l4jTask.setIcon(this.getGenericIcon().getAbsolutePath());
        l4jTask.setManifest(this.getGenericManifest().getAbsolutePath());
        l4jTask.setMainClassName(mainClass);
        l4jTask.setClasspath(new HashSet<String>(packager.getClasspaths()));
        l4jTask.setChdir(useResourcesAsWorkingDir ? "." : "");
        if (bundleJre) {
            l4jTask.setBundledJrePath(jreDirectoryName);
        }
        if (!StringUtils.isBlank((CharSequence)jreMinVersion)) {
            l4jTask.setJreMinVersion(jreMinVersion);
        }
        l4jTask.getJvmOptions().addAll(vmArgs);
        l4jTask.setVersion(winConfig.getProductVersion());
        l4jTask.setTextVersion(winConfig.getTxtProductVersion());
        l4jTask.setCopyright(winConfig.getCopyright());
        l4jTask.setCompanyName(winConfig.getCompanyName());
        l4jTask.setFileDescription(winConfig.getFileDescription());
        l4jTask.setProductName(winConfig.getProductName());
        l4jTask.setInternalName(winConfig.getInternalName());
        l4jTask.setTrademarks(winConfig.getTrademarks());
        l4jTask.setLanguage(winConfig.getLanguage());
        l4jTask.getActions().forEach(action -> action.execute((Object)l4jTask));
        this.sign(this.getGenericExe(), packager);
        FileUtils.copyFileToFile(this.getGenericExe(), executable);
        return this.createBootstrapScript(packager);
    }
}

