/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.gradle;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.MacPackager;
import io.github.fvarrui.javapackager.packagers.Packager;
import java.io.File;
import java.util.UUID;
import org.gradle.api.tasks.bundling.Zip;

public class CreateZipball
extends ArtifactGenerator<Packager> {
    public CreateZipball() {
        super("Zipball");
    }

    @Override
    public boolean skip(Packager packager) {
        return packager.getCreateZipball() == false;
    }

    @Override
    protected File doApply(Packager packager) throws Exception {
        String name = packager.getName();
        String version = packager.getVersion();
        Platform platform = packager.getPlatform();
        File outputDirectory = packager.getOutputDirectory();
        File appFolder = packager.getAppFolder();
        File executable = packager.getExecutable();
        String jreDirectoryName = packager.getJreDirectoryName();
        String zipFileName = packager.getZipballName() != null ? packager.getZipballName() : name + "-" + version + "-" + (Object)((Object)platform) + ".zip";
        File zipFile = new File(outputDirectory, zipFileName);
        Zip zipTask = this.createZipTask();
        zipTask.setProperty("archiveFileName", (Object)zipFile.getName());
        zipTask.setProperty("destinationDirectory", (Object)outputDirectory);
        if (Platform.windows.equals((Object)platform)) {
            zipTask.from((Object)appFolder.getParentFile(), copySpec -> copySpec.include(new String[]{appFolder.getName() + "/**"}));
        } else if (Platform.linux.equals((Object)platform)) {
            zipTask.from((Object)appFolder.getParentFile(), copySpec -> {
                copySpec.include(new String[]{appFolder.getName() + "/**"});
                copySpec.exclude(new String[]{appFolder.getName() + "/" + executable.getName()});
                copySpec.exclude(new String[]{appFolder.getName() + "/" + jreDirectoryName + "/bin/*"});
                copySpec.exclude(new String[]{appFolder.getName() + "/scripts/*"});
            });
            zipTask.from((Object)appFolder.getParentFile(), copySpec -> {
                copySpec.include(new String[]{appFolder.getName() + "/" + executable.getName()});
                copySpec.include(new String[]{appFolder.getName() + "/" + jreDirectoryName + "/bin/*"});
                copySpec.include(new String[]{appFolder.getName() + "/scripts/*"});
                copySpec.setFileMode(Integer.valueOf(493));
            });
        } else if (Platform.mac.equals((Object)platform)) {
            MacPackager macPackager = (MacPackager)packager;
            File appFile = macPackager.getAppFile();
            zipTask.from((Object)appFolder, copySpec -> {
                copySpec.include(new String[]{appFile.getName() + "/**"});
                copySpec.exclude(new String[]{appFile.getName() + "/Contents/MacOS/" + executable.getName()});
                copySpec.exclude(new String[]{appFile.getName() + "/Contents/MacOS/universalJavaApplicationStub"});
                copySpec.exclude(new String[]{appFile.getName() + "/Contents/PlugIns/" + jreDirectoryName + "/Contents/Home/bin/*"});
                copySpec.exclude(new String[]{appFile.getName() + "/Contents/Resources/scripts/*"});
            });
            zipTask.from((Object)appFolder, copySpec -> {
                copySpec.include(new String[]{appFile.getName() + "/Contents/MacOS/" + executable.getName()});
                copySpec.include(new String[]{appFile.getName() + "/Contents/MacOS/universalJavaApplicationStub"});
                copySpec.include(new String[]{appFile.getName() + "/Contents/PlugIns/" + jreDirectoryName + "/Contents/Home/bin/*"});
                copySpec.include(new String[]{appFile.getName() + "/Contents/Resources/scripts/*"});
                copySpec.setFileMode(Integer.valueOf(493));
            });
        }
        zipTask.getActions().forEach(action -> action.execute((Object)zipTask));
        return zipFile;
    }

    private Zip createZipTask() {
        return (Zip)Context.getGradleContext().getProject().getTasks().create("createZipball_" + UUID.randomUUID(), Zip.class);
    }
}

