/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.LinuxPackager;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.util.ArrayList;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.DebMaker;
import org.vafer.jdeb.ant.Data;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.mapping.PermMapper;
import org.vafer.jdeb.producers.DataProducerLink;

public class GenerateDeb
extends ArtifactGenerator<LinuxPackager> {
    private Console console = new Console(){

        public void warn(String message) {
            Logger.warn(message);
        }

        public void info(String message) {
            Logger.info(message);
        }

        public void debug(String message) {
            Logger.debug(message);
        }
    };

    public GenerateDeb() {
        super("DEB package");
    }

    @Override
    public boolean skip(LinuxPackager packager) {
        return !packager.getLinuxConfig().isGenerateDeb();
    }

    @Override
    protected File doApply(LinuxPackager packager) throws Exception {
        File assetsFolder = packager.getAssetsFolder();
        String name = packager.getName();
        File appFolder = packager.getAppFolder();
        File outputDirectory = packager.getOutputDirectory();
        String version = packager.getVersion();
        boolean bundleJre = packager.getBundleJre();
        String jreDirectoryName = packager.getJreDirectoryName();
        File executable = packager.getExecutable();
        File javaFile = new File(appFolder, jreDirectoryName + "/bin/java");
        File mimeXmlFile = packager.getMimeXmlFile();
        File installationPath = packager.getLinuxConfig().getInstallationPath();
        File appPath = new File(installationPath, name);
        File desktopFile = new File(assetsFolder, name + ".desktop");
        VelocityUtils.render("linux/desktop.vtl", desktopFile, packager);
        Logger.info("Desktop file rendered in " + desktopFile.getAbsolutePath());
        File controlFile = new File(assetsFolder, "control");
        VelocityUtils.render("linux/control.vtl", controlFile, packager);
        Logger.info("Control file rendered in " + controlFile.getAbsolutePath());
        File debFile = new File(outputDirectory, name + "_" + version + ".deb");
        ArrayList conffilesProducers = new ArrayList();
        ArrayList<Object> dataProducers = new ArrayList<Object>();
        org.vafer.jdeb.ant.Mapper appFolderMapper = new org.vafer.jdeb.ant.Mapper();
        appFolderMapper.setType("perm");
        appFolderMapper.setPrefix(appPath.getAbsolutePath());
        appFolderMapper.setFileMode("644");
        Data appFolderData = new Data();
        appFolderData.setType("directory");
        appFolderData.setSrc(appFolder);
        appFolderData.setExcludes(executable.getName() + (bundleJre ? "," + jreDirectoryName + "/bin/java," + jreDirectoryName + "/lib/jspawnhelper" : ""));
        appFolderData.addMapper(appFolderMapper);
        dataProducers.add(appFolderData);
        org.vafer.jdeb.ant.Mapper executableMapper = new org.vafer.jdeb.ant.Mapper();
        executableMapper.setType("perm");
        executableMapper.setPrefix(appPath.getAbsolutePath());
        executableMapper.setFileMode("755");
        Data executableData = new Data();
        executableData.setType("file");
        executableData.setSrc(executable);
        executableData.addMapper(executableMapper);
        dataProducers.add(executableData);
        org.vafer.jdeb.ant.Mapper desktopFileMapper = new org.vafer.jdeb.ant.Mapper();
        desktopFileMapper.setType("perm");
        desktopFileMapper.setPrefix("/usr/share/applications");
        Data desktopFileData = new Data();
        desktopFileData.setType("file");
        desktopFileData.setSrc(desktopFile);
        desktopFileData.addMapper(desktopFileMapper);
        dataProducers.add(desktopFileData);
        if (mimeXmlFile != null) {
            org.vafer.jdeb.ant.Mapper mimeXmlFileMapper = new org.vafer.jdeb.ant.Mapper();
            mimeXmlFileMapper.setType("perm");
            mimeXmlFileMapper.setPrefix("/usr/share/mime/packages");
            Data mimeXmlFileData = new Data();
            mimeXmlFileData.setType("file");
            mimeXmlFileData.setSrc(mimeXmlFile);
            mimeXmlFileData.addMapper(mimeXmlFileMapper);
            dataProducers.add(mimeXmlFileData);
        }
        if (bundleJre) {
            org.vafer.jdeb.ant.Mapper javaBinaryMapper = new org.vafer.jdeb.ant.Mapper();
            javaBinaryMapper.setType("perm");
            javaBinaryMapper.setFileMode("755");
            javaBinaryMapper.setPrefix(appPath + "/" + jreDirectoryName + "/bin");
            Data javaBinaryData = new Data();
            javaBinaryData.setType("file");
            javaBinaryData.setSrc(javaFile);
            javaBinaryData.addMapper(javaBinaryMapper);
            dataProducers.add(javaBinaryData);
            File jSpawnHelperFile = new File(appFolder, jreDirectoryName + "/lib/jspawnhelper");
            if (jSpawnHelperFile.exists()) {
                org.vafer.jdeb.ant.Mapper javaSpawnHelperMapper = new org.vafer.jdeb.ant.Mapper();
                javaSpawnHelperMapper.setType("perm");
                javaSpawnHelperMapper.setFileMode("755");
                javaSpawnHelperMapper.setPrefix(appPath + "/" + jreDirectoryName + "/lib");
                Data javaSpawnHelperData = new Data();
                javaSpawnHelperData.setType("file");
                javaSpawnHelperData.setSrc(jSpawnHelperFile);
                javaSpawnHelperData.addMapper(javaSpawnHelperMapper);
                dataProducers.add(javaSpawnHelperData);
            }
        }
        DataProducer linkData = this.createLink("/usr/local/bin/" + executable.getName(), appPath + "/" + executable.getName());
        dataProducers.add(linkData);
        DebMaker debMaker = new DebMaker(this.console, dataProducers, conffilesProducers);
        debMaker.setDeb(debFile);
        debMaker.setControl(controlFile.getParentFile());
        debMaker.setCompression("gzip");
        debMaker.setDigest("SHA256");
        debMaker.validate();
        debMaker.makeDeb();
        return debFile;
    }

    private DataProducer createLink(String name, String target) {
        int linkMode = 0xA000 | Integer.parseInt("777", 8);
        PermMapper linkMapper = new PermMapper(0, 0, "root", "root", linkMode, linkMode, 0, null);
        return new DataProducerLink(name, target, true, null, null, new Mapper[]{linkMapper});
    }
}

