/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.maven;

import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.model.License;

public class ResolveLicenseFromPOM
extends ArtifactGenerator<Packager> {
    public ResolveLicenseFromPOM() {
        super("LICENSE");
    }

    @Override
    protected File doApply(Packager packager) {
        Logger.infoIndent("Trying to resolve license from POM ...");
        File licenseFile = packager.getLicenseFile();
        List licenses = Context.getMavenContext().getEnv().getMavenProject().getLicenses();
        File assetsFolder = packager.getAssetsFolder();
        if (licenseFile == null && !licenses.isEmpty()) {
            String urlStr = null;
            try {
                urlStr = ((License)licenses.get(0)).getUrl();
                URL licenseUrl = new URL(urlStr);
                licenseFile = new File(assetsFolder, "LICENSE");
                FileUtils.downloadFromUrl(licenseUrl, licenseFile);
            }
            catch (MalformedURLException e) {
                Logger.error("Invalid license URL specified: " + urlStr);
                licenseFile = null;
            }
            catch (IOException e) {
                Logger.error("Cannot download license from " + urlStr);
                licenseFile = null;
            }
        }
        if (licenseFile != null) {
            Logger.infoUnindent("License resolved " + licenseFile + "!");
        } else {
            Logger.infoUnindent("License not resolved!");
        }
        return licenseFile;
    }
}

