/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.model;

import io.github.fvarrui.javapackager.model.ValueType;
import java.io.Serializable;

public class RegistryEntry
implements Serializable {
    private static final long serialVersionUID = 447936480111873679L;
    private String key;
    private String valueName;
    private ValueType valueType = ValueType.REG_SZ;
    private String valueData = "";

    public RegistryEntry() {
    }

    public RegistryEntry(String key, String valueName, ValueType valueType, String valueData) {
        this.key = key;
        this.valueName = valueName;
        this.valueType = valueType;
        this.valueData = valueData;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public String getValueData() {
        return this.valueData;
    }

    public void setValueData(String valueData) {
        this.valueData = valueData;
    }

    public String getRoot() {
        return this.key.split(":")[0];
    }

    public String getSubkey() {
        String subkey = this.key.split(":")[1];
        return subkey.startsWith("/") ? subkey.substring(1) : subkey;
    }

    public String getValueTypeAsInnoSetupString() {
        switch (this.valueType) {
            case REG_BINARY: {
                return "binary";
            }
            case REG_DWORD: {
                return "dword";
            }
            case REG_EXPAND_SZ: {
                return "expandsz";
            }
            case REG_MULTI_SZ: {
                return "multisz";
            }
            case REG_QWORD: {
                return "qword";
            }
            case REG_SZ: {
                return "string";
            }
        }
        return "none";
    }

    public String getValueTypeAsWIXToolsetString() {
        switch (this.valueType) {
            case REG_BINARY: {
                return "binary";
            }
            case REG_DWORD: {
                return "integer";
            }
            case REG_EXPAND_SZ: {
                return "expandable";
            }
            case REG_MULTI_SZ: {
                return "multiString";
            }
            case REG_QWORD: {
                return "integer";
            }
            case REG_SZ: {
                return "string";
            }
        }
        return "none";
    }

    public String toString() {
        return "RegistryEntry [key=" + this.key + ", valueName=" + this.valueName + ", valueType=" + (Object)((Object)this.valueType) + ", valueData=" + this.valueData + "]";
    }
}

