/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.utils;

import io.github.fvarrui.javapackager.model.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class JDKUtils {
    private static Map<String, String> getRelease(File jdkPath) throws IOException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        File releaseFile = new File(jdkPath, "release");
        if (!releaseFile.exists()) {
            return propertiesMap;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(releaseFile));
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> propertiesMap.put(key.toString(), value.toString().replaceAll("^\"|\"$", ""))));
        return propertiesMap;
    }

    private static boolean checkPlatform(Platform platform, File jdkPath) throws FileNotFoundException, IOException {
        Map<String, String> releaseMap = JDKUtils.getRelease(jdkPath);
        String osName = releaseMap.get("OS_NAME");
        switch (platform) {
            case linux: {
                return "Linux".equalsIgnoreCase(osName);
            }
            case mac: {
                return "Darwin".equalsIgnoreCase(osName);
            }
            case windows: {
                return "Windows".equalsIgnoreCase(osName);
            }
        }
        return false;
    }

    public static boolean isValidJDK(Platform platform, File jdkPath) throws FileNotFoundException, IOException {
        return jdkPath != null && jdkPath.isDirectory() && JDKUtils.checkPlatform(platform, jdkPath);
    }

    public static boolean isValidJRE(Platform platform, File jrePath) throws IOException {
        return jrePath != null && jrePath.isDirectory() && (JDKUtils.checkPlatform(platform, jrePath) || new File(jrePath, "bin/java").exists() || new File(jrePath, "bin/java.exe").exists());
    }
}

