/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.utils;

import java.util.ArrayList;

public class VersionUtils {
    private static Integer[] parseVersion(String version) {
        String[] splittedVersion = version.split("\\.");
        ArrayList<Integer> parsedVersion = new ArrayList<Integer>();
        for (int i = 0; i < splittedVersion.length; ++i) {
            try {
                parsedVersion.add(Integer.parseInt(splittedVersion[i]));
                continue;
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        return parsedVersion.toArray(new Integer[0]);
    }

    public static int compareVersions(String v1, String v2) {
        Integer[] parsed1 = VersionUtils.parseVersion(v1);
        Integer[] parsed2 = VersionUtils.parseVersion(v2);
        int size = Math.min(parsed1.length, parsed2.length);
        for (int i = 0; i < size; ++i) {
            if (parsed1[i] > parsed2[i]) {
                return -1;
            }
            if (parsed1[i] >= parsed2[i]) continue;
            return 1;
        }
        return 0;
    }

    public static int getJavaMajorVersion() {
        Integer[] parsed = VersionUtils.parseVersion(System.getProperty("java.version"));
        int major = parsed[0];
        if (major >= 2) {
            return major;
        }
        return parsed[1];
    }
}

