/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.gradle;

import edu.sc.seis.launch4j.tasks.Launch4jLibraryTask;
import io.github.fvarrui.javapackager.model.WindowsConfig;
import io.github.fvarrui.javapackager.model.WindowsExeCreationTool;
import io.github.fvarrui.javapackager.packagers.AbstractCreateWindowsExe;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.FileUtils;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CreateWindowsExeLaunch4j
extends AbstractCreateWindowsExe {
    public CreateWindowsExeLaunch4j() {
        super(WindowsExeCreationTool.launch4j);
    }

    @Override
    protected File doApply(WindowsPackager packager) throws Exception {
        String jarPath;
        List<String> vmArgs = packager.getVmArgs();
        WindowsConfig winConfig = packager.getWinConfig();
        File executable = packager.getExecutable();
        String mainClass = packager.getMainClass();
        boolean useResourcesAsWorkingDir = packager.isUseResourcesAsWorkingDir();
        boolean bundleJre = packager.getBundleJre();
        String jreDirectoryName = packager.getJreDirectoryName();
        String jreMinVersion = packager.getJreMinVersion();
        File jarFile = packager.getJarFile();
        File appFolder = packager.getAppFolder();
        this.createAssets(packager);
        if (winConfig.isWrapJar()) {
            jarPath = this.getGenericJar().getAbsolutePath();
        } else {
            FileUtils.copyFileToFolder(jarFile, appFolder);
            jarPath = jarFile.getName();
        }
        Launch4jLibraryTask l4jTask = Context.getGradleContext().getLibraryTask();
        l4jTask.getDuplicatesStrategy().set((Object)Context.getGradleContext().getDuplicatesStrategy());
        l4jTask.getOutputs().upToDateWhen(task -> false);
        l4jTask.getHeaderType().set((Object)winConfig.getHeaderType().toString());
        l4jTask.getJarFiles().set((Object)Context.getGradleContext().getProject().files(new Object[]{jarPath}));
        l4jTask.getDontWrapJar().set((Object)(!winConfig.isWrapJar() ? 1 : 0));
        l4jTask.getOutfile().set((Object)this.getGenericExe().getName());
        l4jTask.getIcon().set((Object)this.getGenericIcon().getAbsolutePath());
        l4jTask.getManifest().set((Object)this.getGenericManifest().getAbsolutePath());
        l4jTask.getMainClassName().set((Object)mainClass);
        l4jTask.getClasspath().set(new HashSet<String>(packager.getClasspaths()));
        l4jTask.getChdir().set((Object)(useResourcesAsWorkingDir ? "." : ""));
        if (bundleJre) {
            l4jTask.getBundledJrePath().set((Object)jreDirectoryName);
        }
        if (!StringUtils.isBlank((CharSequence)jreMinVersion)) {
            l4jTask.getJreMinVersion().set((Object)jreMinVersion);
        }
        l4jTask.getJvmOptions().addAll(vmArgs);
        l4jTask.getVersion().set((Object)winConfig.getProductVersion());
        l4jTask.getTextVersion().set((Object)winConfig.getTxtProductVersion());
        l4jTask.getCopyright().set((Object)winConfig.getCopyright());
        l4jTask.getCompanyName().set((Object)winConfig.getCompanyName());
        l4jTask.getFileDescription().set((Object)winConfig.getFileDescription());
        l4jTask.getProductName().set((Object)winConfig.getProductName());
        l4jTask.getInternalName().set((Object)winConfig.getInternalName());
        l4jTask.getTrademarks().set((Object)winConfig.getTrademarks());
        l4jTask.getLanguage().set((Object)winConfig.getLanguage());
        l4jTask.getActions().forEach(action -> action.execute((Object)l4jTask));
        FileUtils.copyFileToFile(this.getGenericExe(), executable);
        return this.createBootstrapScript(packager);
    }
}

