/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.maven;

import io.github.fvarrui.javapackager.model.Manifest;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.MojoExecutorUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class CreateRunnableJar
extends ArtifactGenerator<Packager> {
    public CreateRunnableJar() {
        super("Runnable JAR");
    }

    @Override
    protected File doApply(Packager packager) {
        String classifier = "runnable";
        String mainClass = packager.getMainClass();
        File outputDirectory = packager.getOutputDirectory();
        MojoExecutor.ExecutionEnvironment env = Context.getMavenContext().getEnv();
        Manifest manifest = packager.getManifest();
        ArrayList<MojoExecutor.Element> archive = new ArrayList<MojoExecutor.Element>();
        archive.add(MojoExecutor.element((String)"manifest", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"addClasspath", (String)"true"), MojoExecutor.element((String)"classpathPrefix", (String)"libs/"), MojoExecutor.element((String)"mainClass", (String)mainClass), MojoExecutor.element((String)"useUniqueVersions", (String)"false")}));
        if (manifest != null) {
            archive.add(MojoExecutorUtils.mapToElement("manifestEntries", manifest.getAdditionalEntries()));
            List<MojoExecutor.Element> manifestSections = manifest.getSections().stream().map(s -> MojoExecutor.element((String)"manifestSection", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"Name", (String)s.getName()), MojoExecutorUtils.mapToElement("manifestEntries", s.getEntries())})).collect(Collectors.toList());
            archive.add(MojoExecutor.element((String)"manifestSections", (MojoExecutor.Element[])manifestSections.toArray(new MojoExecutor.Element[manifestSections.size()])));
        }
        try {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-jar-plugin"), (String)MojoExecutor.version((String)"3.3.0")), (String)MojoExecutor.goal((String)"jar"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"classifier", (String)classifier), MojoExecutor.element((String)"archive", (MojoExecutor.Element[])archive.toArray(new MojoExecutor.Element[archive.size()])), MojoExecutor.element((String)"outputDirectory", (String)outputDirectory.getAbsolutePath())}), (MojoExecutor.ExecutionEnvironment)env);
        }
        catch (MojoExecutionException e) {
            Logger.error("Runnable jar creation failed! " + e.getMessage());
            throw new RuntimeException(e);
        }
        String finalName = Context.getMavenContext().getEnv().getMavenProject().getBuild().getFinalName();
        return new File(outputDirectory, finalName + "-" + classifier + ".jar");
    }
}

