/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.maven;

import io.github.fvarrui.javapackager.model.Arch;
import io.github.fvarrui.javapackager.model.WindowsConfig;
import io.github.fvarrui.javapackager.model.WindowsExeCreationTool;
import io.github.fvarrui.javapackager.packagers.AbstractCreateWindowsExe;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class CreateWindowsExeLaunch4j
extends AbstractCreateWindowsExe {
    public CreateWindowsExeLaunch4j() {
        super(WindowsExeCreationTool.launch4j);
    }

    @Override
    protected File doApply(WindowsPackager packager) throws Exception {
        String jarPath;
        List<String> vmArgs = packager.getVmArgs();
        WindowsConfig winConfig = packager.getWinConfig();
        File executable = packager.getExecutable();
        String mainClass = packager.getMainClass();
        boolean useResourcesAsWorkingDir = packager.isUseResourcesAsWorkingDir();
        boolean bundleJre = packager.getBundleJre();
        String jreDirectoryName = packager.getJreDirectoryName();
        String classpath = packager.getClasspath();
        String jreMinVersion = packager.getJreMinVersion();
        File jarFile = packager.getJarFile();
        File appFolder = packager.getAppFolder();
        Arch arch = packager.getArch();
        this.createAssets(packager);
        if (arch != Arch.x86) {
            Logger.warn("Launch4J only can generate 32-bit executable");
        }
        if (winConfig.isWrapJar()) {
            jarPath = this.getGenericJar().getAbsolutePath();
        } else {
            FileUtils.copyFileToFolder(jarFile, appFolder);
            jarPath = jarFile.getName();
        }
        ArrayList<MojoExecutor.Element> jreElements = new ArrayList<MojoExecutor.Element>();
        jreElements.add(MojoExecutor.element((String)"opts", (MojoExecutor.Element[])((MojoExecutor.Element[])vmArgs.stream().map(arg -> MojoExecutor.element((String)"opt", (String)arg)).toArray(MojoExecutor.Element[]::new))));
        jreElements.add(MojoExecutor.element((String)"path", (String)(bundleJre ? jreDirectoryName : "%JAVA_HOME%;%PATH%")));
        if (!StringUtils.isBlank((CharSequence)jreMinVersion)) {
            jreElements.add(MojoExecutor.element((String)"minVersion", (String)jreMinVersion));
        }
        ArrayList<MojoExecutor.Element> pluginConfig = new ArrayList<MojoExecutor.Element>();
        pluginConfig.add(MojoExecutor.element((String)"headerType", (String)("" + (Object)((Object)winConfig.getHeaderType()))));
        pluginConfig.add(MojoExecutor.element((String)"jar", (String)jarPath));
        pluginConfig.add(MojoExecutor.element((String)"dontWrapJar", (String)("" + !winConfig.isWrapJar())));
        pluginConfig.add(MojoExecutor.element((String)"outfile", (String)this.getGenericExe().getAbsolutePath()));
        pluginConfig.add(MojoExecutor.element((String)"icon", (String)this.getGenericIcon().getAbsolutePath()));
        pluginConfig.add(MojoExecutor.element((String)"manifest", (String)this.getGenericManifest().getAbsolutePath()));
        pluginConfig.add(MojoExecutor.element((String)"classPath", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"mainClass", (String)mainClass), MojoExecutor.element((String)"preCp", (String)classpath), MojoExecutor.element((String)"addDependencies", (String)"false")}));
        pluginConfig.add(MojoExecutor.element((String)"chdir", (String)(useResourcesAsWorkingDir ? "." : "")));
        pluginConfig.add(MojoExecutor.element((String)"jre", (MojoExecutor.Element[])jreElements.toArray(new MojoExecutor.Element[0])));
        pluginConfig.add(MojoExecutor.element((String)"versionInfo", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"fileVersion", (String)winConfig.getFileVersion()), MojoExecutor.element((String)"txtFileVersion", (String)winConfig.getTxtFileVersion()), MojoExecutor.element((String)"productVersion", (String)winConfig.getProductVersion()), MojoExecutor.element((String)"txtProductVersion", (String)winConfig.getTxtProductVersion()), MojoExecutor.element((String)"copyright", (String)winConfig.getCopyright()), MojoExecutor.element((String)"companyName", (String)winConfig.getCompanyName()), MojoExecutor.element((String)"fileDescription", (String)winConfig.getFileDescription()), MojoExecutor.element((String)"productName", (String)winConfig.getProductName()), MojoExecutor.element((String)"internalName", (String)winConfig.getInternalName()), MojoExecutor.element((String)"originalFilename", (String)winConfig.getOriginalFilename()), MojoExecutor.element((String)"trademarks", (String)winConfig.getTrademarks()), MojoExecutor.element((String)"language", (String)winConfig.getLanguage())}));
        try {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.akathist.maven.plugins.launch4j"), (String)MojoExecutor.artifactId((String)"launch4j-maven-plugin"), (String)MojoExecutor.version((String)"2.4.1")), (String)MojoExecutor.goal((String)"launch4j"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])pluginConfig.toArray(new MojoExecutor.Element[0])), (MojoExecutor.ExecutionEnvironment)Context.getMavenContext().getEnv());
            FileUtils.copyFileToFile(this.getGenericExe(), executable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return this.createBootstrapScript(packager);
    }
}

