/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.maven;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class CreateZipball
extends ArtifactGenerator<Packager> {
    public CreateZipball() {
        super("Zipball");
    }

    @Override
    public boolean skip(Packager packager) {
        return packager.getCreateZipball() == false;
    }

    @Override
    protected File doApply(Packager packager) {
        File assetsFolder = packager.getAssetsFolder();
        Platform platform = packager.getPlatform();
        File outputDirectory = packager.getOutputDirectory();
        try {
            File assemblyFile = new File(assetsFolder, "assembly-zipball-" + (Object)((Object)platform) + ".xml");
            VelocityUtils.render((Object)((Object)platform) + "/assembly.xml.vtl", assemblyFile, packager);
            String format = "zip";
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-assembly-plugin"), (String)MojoExecutor.version((String)"3.1.1")), (String)MojoExecutor.goal((String)"single"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"outputDirectory", (String)outputDirectory.getAbsolutePath()), MojoExecutor.element((String)"formats", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"format", (String)format)}), MojoExecutor.element((String)"descriptors", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"descriptor", (String)assemblyFile.getAbsolutePath())}), MojoExecutor.element((String)"appendAssemblyId", (String)"false")}), (MojoExecutor.ExecutionEnvironment)Context.getMavenContext().getEnv());
            String finalName = Context.getMavenContext().getEnv().getMavenProject().getBuild().getFinalName();
            File finalFile = new File(outputDirectory, finalName + "." + format);
            String zipName = packager.getZipballName() != null ? packager.getZipballName() : finalName + "-" + (Object)((Object)platform);
            File zipFile = new File(outputDirectory, zipName + "." + format);
            finalFile.renameTo(zipFile);
            return zipFile;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

