/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.maven;

import io.github.fvarrui.javapackager.maven.CopyDependencies;
import io.github.fvarrui.javapackager.maven.CreateRunnableJar;
import io.github.fvarrui.javapackager.maven.CreateTarball;
import io.github.fvarrui.javapackager.maven.CreateWindowsExeLaunch4j;
import io.github.fvarrui.javapackager.maven.CreateZipball;
import io.github.fvarrui.javapackager.maven.ResolveLicenseFromPOM;
import io.github.fvarrui.javapackager.packagers.AbstractCreateWindowsExe;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.CreateWindowsExeWhy;
import io.github.fvarrui.javapackager.packagers.CreateWindowsExeWinRun4j;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import java.io.File;
import java.time.Year;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Organization;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenContext
extends Context<Log> {
    private Log logger;
    private MojoExecutor.ExecutionEnvironment env;

    public MavenContext(MojoExecutor.ExecutionEnvironment env, Log logger) {
        this.env = env;
        this.logger = logger;
        MavenProject project = env.getMavenProject();
        if (project.getOrganization() == null) {
            project.setOrganization(new Organization());
        }
        if (StringUtils.isBlank((CharSequence)project.getOrganization().getName())) {
            project.getOrganization().setName("ACME");
        }
        if (StringUtils.isBlank((CharSequence)project.getInceptionYear())) {
            project.setInceptionYear(Year.now().toString());
        }
        if (StringUtils.isBlank((CharSequence)project.getDescription())) {
            project.setDescription(project.getArtifactId());
        }
    }

    public MojoExecutor.ExecutionEnvironment getEnv() {
        return this.env;
    }

    @Override
    public Log getLogger() {
        return this.logger;
    }

    @Override
    public File getRootDir() {
        return this.env.getMavenProject().getBasedir();
    }

    @Override
    public File getBuildDir() {
        return new File(this.env.getMavenProject().getBuild().getDirectory());
    }

    @Override
    public File createRunnableJar(Packager packager) throws Exception {
        return new CreateRunnableJar().apply(packager);
    }

    @Override
    public File copyDependencies(Packager packager) throws Exception {
        return new CopyDependencies().apply(packager);
    }

    @Override
    public File createTarball(Packager packager) throws Exception {
        return new CreateTarball().apply(packager);
    }

    @Override
    public File createZipball(Packager packager) throws Exception {
        return new CreateZipball().apply(packager);
    }

    @Override
    public File resolveLicense(Packager packager) throws Exception {
        return new ResolveLicenseFromPOM().apply(packager);
    }

    @Override
    public File createWindowsExe(WindowsPackager packager) throws Exception {
        AbstractCreateWindowsExe createWindowsExe;
        switch (packager.getWinConfig().getExeCreationTool()) {
            case launch4j: {
                createWindowsExe = new CreateWindowsExeLaunch4j();
                break;
            }
            case why: {
                createWindowsExe = new CreateWindowsExeWhy();
                break;
            }
            case winrun4j: {
                createWindowsExe = new CreateWindowsExeWinRun4j();
                break;
            }
            default: {
                return null;
            }
        }
        if (!createWindowsExe.skip(packager)) {
            return createWindowsExe.apply(packager);
        }
        return null;
    }
}

