/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.model;

import org.apache.commons.lang3.SystemUtils;
import org.redline_rpm.header.Architecture;

public enum Arch {
    aarch64,
    x64,
    x86;


    public static Arch getArch(String archString) {
        switch (archString) {
            case "x86": 
            case "i386": 
            case "i486": 
            case "i586": 
            case "i686": {
                return x86;
            }
            case "x86_64": 
            case "amd64": {
                return x64;
            }
            case "aarch64": {
                return aarch64;
            }
        }
        throw new IllegalArgumentException("Unknown architecture " + archString);
    }

    public static Arch getDefault() {
        return Arch.getArch(SystemUtils.OS_ARCH);
    }

    public String toDebArchitecture() {
        switch (this.ordinal()) {
            case 0: {
                return "arm64";
            }
            case 1: {
                return "amd64";
            }
            case 2: {
                return "i386";
            }
        }
        return null;
    }

    public Architecture toRpmArchitecture() {
        switch (this.ordinal()) {
            case 0: {
                return Architecture.AARCH64;
            }
            case 1: {
                return Architecture.X86_64;
            }
            case 2: {
                return Architecture.I386;
            }
        }
        return null;
    }

    public String toMsiArchitecture() {
        switch (this.ordinal()) {
            case 0: {
                return "arm64";
            }
            case 1: {
                return "x64";
            }
            case 2: {
                return "x86";
            }
        }
        return null;
    }
}

