/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.model.WindowsExeCreationTool;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;

public abstract class AbstractCreateWindowsExe
extends ArtifactGenerator<WindowsPackager> {
    private final File outputFolder;
    private File genericManifest;
    private File genericIcon;
    private File genericJar;
    private File genericExe;

    public AbstractCreateWindowsExe(WindowsExeCreationTool tool) {
        super(tool.toString());
        this.outputFolder = new File(Context.getContext().getBuildDir(), tool.toString());
    }

    public File getGenericManifest() {
        return this.genericManifest;
    }

    public void setGenericManifest(File genericManifest) {
        this.genericManifest = genericManifest;
    }

    public File getGenericIcon() {
        return this.genericIcon;
    }

    public void setGenericIcon(File genericIcon) {
        this.genericIcon = genericIcon;
    }

    public File getGenericJar() {
        return this.genericJar;
    }

    public void setGenericJar(File genericJar) {
        this.genericJar = genericJar;
    }

    public File getGenericExe() {
        return this.genericExe;
    }

    public void setGenericExe(File genericExe) {
        this.genericExe = genericExe;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    protected void createAssets(WindowsPackager packager) throws Exception {
        File manifestFile = packager.getManifestFile();
        File iconFile = packager.getIconFile();
        File jarFile = packager.getJarFile();
        FileUtils.mkdir(this.outputFolder);
        this.genericManifest = new File(this.outputFolder, "app.exe.manifest");
        this.genericIcon = new File(this.outputFolder, "app.ico");
        this.genericJar = new File(this.outputFolder, "app.jar");
        this.genericExe = new File(this.outputFolder, "app.exe");
        FileUtils.copyFileToFile(manifestFile, this.genericManifest);
        FileUtils.copyFileToFile(iconFile, this.genericIcon);
        FileUtils.copyFileToFile(jarFile, this.genericJar);
    }

    protected File createBootstrapScript(WindowsPackager packager) throws Exception {
        File executable = packager.getExecutable();
        if (FileUtils.exists(packager.getScripts().getBootstrap())) {
            File vbsFile = new File(packager.getAppFolder(), packager.getName() + ".vbs");
            VelocityUtils.render((Object)((Object)Platform.windows) + "/startup.vbs.vtl", vbsFile, packager);
            executable = vbsFile;
        }
        return executable;
    }
}

