/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.GenerateMsm;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import io.github.fvarrui.javapackager.utils.XMLUtils;
import java.io.File;
import net.jsign.WindowsSigner;

public class GenerateMsi
extends ArtifactGenerator<WindowsPackager> {
    public GenerateMsi() {
        super("MSI installer");
    }

    @Override
    public boolean skip(WindowsPackager packager) {
        if (!packager.getWinConfig().isGenerateMsi()) {
            return true;
        }
        if (!packager.getPlatform().isCurrentPlatform() && !packager.isForceInstaller()) {
            Logger.warn(this.getArtifactName() + " cannot be generated due to the target platform (" + (Object)((Object)packager.getPlatform()) + ") is different from the execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + ")!");
            return true;
        }
        return false;
    }

    @Override
    protected File doApply(WindowsPackager packager) throws Exception {
        File msmFile = new GenerateMsm().doApply(packager);
        Logger.info("MSM file generated in " + msmFile);
        File assetsFolder = packager.getAssetsFolder();
        String name = packager.getName();
        File outputDirectory = packager.getOutputDirectory();
        String version = packager.getVersion();
        File wxsFile = new File(assetsFolder, name + ".wxs");
        VelocityUtils.render("windows/wxs.vtl", wxsFile, packager);
        Logger.info("WXS file generated in " + wxsFile + "!");
        XMLUtils.prettify(wxsFile);
        Logger.info("Compiling file " + wxsFile);
        File wixobjFile = new File(assetsFolder, name + ".wixobj");
        CommandUtils.execute("candle", "-out", wixobjFile, wxsFile);
        Logger.info("WIXOBJ file generated in " + wixobjFile + "!");
        Logger.info("Linking file " + wixobjFile);
        File msiFile = new File(outputDirectory, name + "_" + version + ".msi");
        CommandUtils.execute("light", "-sw1076", "-spdb", "-out", msiFile, wixobjFile);
        if (!msiFile.exists()) {
            throw new Exception("MSI installer file generation failed!");
        }
        WindowsSigner.sign(msiFile, packager.getDisplayName(), packager.getUrl(), packager.getWinConfig().getSigning());
        return msiFile;
    }
}

