/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import io.github.fvarrui.javapackager.utils.XMLUtils;
import java.io.File;

public class GenerateMsm
extends ArtifactGenerator<WindowsPackager> {
    public GenerateMsm() {
        super("MSI merge module");
    }

    @Override
    public boolean skip(WindowsPackager packager) {
        if (!packager.getWinConfig().isGenerateMsm() && !packager.getWinConfig().isGenerateMsi()) {
            return true;
        }
        if (!packager.getPlatform().isCurrentPlatform() && !packager.isForceInstaller()) {
            Logger.warn(this.getArtifactName() + " cannot be generated due to the target platform (" + (Object)((Object)packager.getPlatform()) + ") is different from the execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + ")!");
            return true;
        }
        return false;
    }

    @Override
    protected File doApply(WindowsPackager packager) throws Exception {
        if (packager.getMsmFile() != null) {
            return packager.getMsmFile();
        }
        File assetsFolder = packager.getAssetsFolder();
        String name = packager.getName();
        File outputDirectory = packager.getOutputDirectory();
        String version = packager.getVersion();
        File wxsFile = new File(assetsFolder, name + ".msm.wxs");
        VelocityUtils.render("windows/msm.wxs.vtl", wxsFile, packager);
        Logger.info("WXS file generated in " + wxsFile + "!");
        XMLUtils.prettify(wxsFile);
        Logger.info("Compiling file " + wxsFile);
        File wixobjFile = new File(assetsFolder, name + ".msm.wixobj");
        CommandUtils.execute("candle", "-out", wixobjFile, wxsFile);
        Logger.info("WIXOBJ file generated in " + wixobjFile + "!");
        Logger.info("Linking file " + wixobjFile);
        File msmFile = new File(outputDirectory, name + "_" + version + ".msm");
        CommandUtils.execute("light", "-sw1076", "-spdb", "-out", msmFile, wixobjFile);
        if (!msmFile.exists()) {
            throw new Exception("MSI installer file generation failed!");
        }
        packager.setMsmFile(msmFile);
        return msmFile;
    }
}

