/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.LinuxPackager;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.redline_rpm.Builder;
import org.redline_rpm.header.Architecture;
import org.redline_rpm.header.Os;
import org.redline_rpm.header.RpmType;

public class GenerateRpm
extends ArtifactGenerator<LinuxPackager> {
    public GenerateRpm() {
        super("RPM package");
    }

    @Override
    public boolean skip(LinuxPackager packager) {
        return !packager.getLinuxConfig().isGenerateRpm();
    }

    @Override
    protected File doApply(LinuxPackager packager) throws Exception {
        File appFolder = packager.getAppFolder();
        String name = packager.getName();
        String version = packager.getVersion().replaceAll("-", "_");
        String description = packager.getDescription();
        String organizationName = packager.getOrganizationName();
        File outputDirectory = packager.getOutputDirectory();
        File executable = packager.getExecutable();
        File assetsFolder = packager.getAssetsFolder();
        String jreDirectoryName = packager.getJreDirectoryName();
        Architecture arch = packager.getArch().toRpmArchitecture();
        File mimeXmlFile = packager.getMimeXmlFile();
        String installationPath = packager.getLinuxConfig().getInstallationPath();
        String appPath = installationPath + "/" + name;
        File desktopFile = new File(assetsFolder, name + ".desktop");
        VelocityUtils.render("linux/desktop.vtl", desktopFile, packager);
        Logger.info("Desktop file rendered in " + desktopFile.getAbsolutePath());
        FileUtils.copyFileToFolder(desktopFile, appFolder);
        Builder builder = new Builder();
        builder.setType(RpmType.BINARY);
        builder.setPlatform(arch, Os.LINUX);
        builder.setPackage((CharSequence)name, (CharSequence)version, (CharSequence)"1");
        builder.setPackager((CharSequence)organizationName);
        builder.setDescription((CharSequence)description);
        builder.setPrefixes(new String[]{installationPath});
        ArrayList<File> executionPermissions = new ArrayList<File>();
        executionPermissions.add(executable);
        executionPermissions.add(new File(appFolder, jreDirectoryName + "/bin/java"));
        executionPermissions.add(new File(appFolder, jreDirectoryName + "/lib/jspawnhelper"));
        this.addDirectory(builder, installationPath, appFolder, executionPermissions);
        this.addLink(builder, "/usr/share/applications/" + desktopFile.getName(), appPath + "/" + desktopFile.getName());
        if (mimeXmlFile != null) {
            FileUtils.copyFileToFolder(mimeXmlFile, appFolder);
            this.addLink(builder, "/usr/share/mime/packages/" + mimeXmlFile.getName(), appPath + "/" + mimeXmlFile.getName());
        }
        this.addLink(builder, "/usr/local/bin/" + executable.getName(), appPath + "/" + executable.getName());
        this.addDirectory(builder, installationPath, appFolder, executionPermissions);
        builder.build(outputDirectory);
        String suffix = "-1." + arch + ".rpm";
        File originalRpm = new File(outputDirectory, name + "-" + version + suffix);
        File rpm = null;
        if (originalRpm.exists()) {
            rpm = new File(outputDirectory, name + "_" + version + ".rpm");
            if (rpm.exists()) {
                rpm.delete();
            }
            FileUtils.rename(originalRpm, rpm.getName());
        }
        return rpm;
    }

    private void addLink(Builder builder, String path, String target) throws NoSuchAlgorithmException, IOException {
        Logger.info("Adding link '" + path + "' to RPM builder targeting '" + target + "'");
        builder.addLink(path, target);
    }

    private void addFile(Builder builder, String rootPath, File file, int mode) throws NoSuchAlgorithmException, IOException {
        String filePath = rootPath + "/" + file.getName();
        Logger.info("Adding file '" + file + "' to RPM builder as '" + filePath + "'");
        builder.addFile(filePath, file, mode);
    }

    private void addDirectory(Builder builder, String parentPath, File directory, List<File> executionPermissions) throws NoSuchAlgorithmException, IOException {
        String dirPath = parentPath + "/" + directory.getName();
        Logger.info("Adding directory '" + directory + "' to RPM builder as '" + dirPath + "'");
        builder.addDirectory(dirPath);
        for (File f : Objects.requireNonNull(directory.listFiles())) {
            if (f.isDirectory()) {
                this.addDirectory(builder, dirPath, f, executionPermissions);
                continue;
            }
            this.addFile(builder, dirPath, f, executionPermissions.contains(f) ? 493 : 420);
        }
    }
}

