/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.utils;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {
    public static File mkdir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File mkdir(File parent, String name) {
        File dir = new File(parent, name);
        return FileUtils.mkdir(dir);
    }

    public static void copyFileToFile(File source, File dest) throws Exception {
        Logger.info("Copying file [" + source + "] to file [" + dest + "]");
        try {
            org.apache.commons.io.FileUtils.copyFile((File)source, (File)dest);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static void copyFileToFolder(File source, File destFolder) throws Exception {
        FileUtils.copyFileToFolder(source, destFolder, false);
    }

    public static void copyFileToFolder(File source, File destFolder, boolean overwrite) throws Exception {
        Logger.info("Copying file [" + source + "] to folder [" + destFolder + "]");
        File destFile = new File(destFolder, source.getName());
        if (destFile.exists() && !overwrite) {
            return;
        }
        try {
            if (Platform.windows.isCurrentPlatform()) {
                Files.copy(source.toPath(), destFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
            } else {
                CommandUtils.execute("cp", source, destFile);
            }
        }
        catch (IOException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static void concat(File dest, File ... sources) throws Exception {
        Logger.info("Concatenating files [" + StringUtils.join((Object[])sources, (String)",") + "] into file [" + dest + "]");
        try {
            FileOutputStream fos = new FileOutputStream(dest);
            for (File source : sources) {
                FileInputStream fis = new FileInputStream(source);
                IOUtils.copy((InputStream)fis, (OutputStream)fos);
                fis.close();
            }
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new Exception("Error concatenating streams", e);
        }
    }

    public static void copyFolderToFolder(File from, File to) throws Exception {
        Logger.info("Copying folder [" + from + "] to folder [" + to + "]");
        if (!from.isDirectory()) {
            throw new Exception("Source folder " + from + " is not a directory");
        }
        try {
            if (Platform.windows.isCurrentPlatform()) {
                org.apache.commons.io.FileUtils.copyDirectoryToDirectory((File)from, (File)to);
            } else {
                CommandUtils.execute("cp", "-R", from, to);
            }
        }
        catch (IOException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static void copyFolderContentToFolder(File from, File to) throws Exception {
        Logger.info("Copying folder content [" + from + "] to folder [" + to + "]");
        if (!from.isDirectory()) {
            throw new Exception("Source folder " + from + " is not a directory");
        }
        if (!to.exists()) {
            to.mkdirs();
        } else if (!to.isDirectory()) {
            throw new Exception("Destination folder " + to + " is not a directory");
        }
        for (File file : from.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.copyFolderToFolder(file, to);
                continue;
            }
            FileUtils.copyFileToFolder(file, to);
        }
    }

    public static void moveFolderToFolder(File from, File to) throws Exception {
        Logger.info("Moving folder [" + from + "] to folder [" + to + "]");
        if (!from.isDirectory()) {
            throw new Exception("Source folder " + from + " is not a directory");
        }
        if (to.exists() && !to.isDirectory()) {
            throw new Exception("Destination folder " + to + " is not a directory");
        }
        try {
            org.apache.commons.io.FileUtils.moveDirectoryToDirectory((File)from, (File)to, (boolean)true);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static void moveFolderContentToFolder(File from, File to) throws Exception {
        Logger.info("Moving folder content [" + from + "] to folder [" + to + "]");
        if (!from.isDirectory()) {
            throw new Exception("Source folder " + from + " is not a directory");
        }
        if (!to.isDirectory()) {
            throw new Exception("Destination folder " + to + " is not a directory");
        }
        try {
            for (File file : from.listFiles()) {
                if (file.isDirectory()) {
                    org.apache.commons.io.FileUtils.moveDirectoryToDirectory((File)file, (File)to, (boolean)true);
                    continue;
                }
                org.apache.commons.io.FileUtils.moveFileToDirectory((File)file, (File)to, (boolean)true);
            }
        }
        catch (IOException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static void moveFileToFolder(File from, File to) throws Exception {
        Logger.info("Moving file [" + from + "] to folder [" + to + "]");
        if (!from.isFile()) {
            throw new Exception("Source file " + from + " is not a file");
        }
        if (!to.exists()) {
            to.mkdirs();
        }
        try {
            org.apache.commons.io.FileUtils.moveFileToDirectory((File)from, (File)to, (boolean)true);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private static void copyStreamToFile(InputStream is, File dest) throws Exception {
        try {
            org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)is, (File)dest);
        }
        catch (IOException ex) {
            throw new Exception("Could not copy input stream to " + dest, ex);
        }
    }

    public static void copyResourceToFile(String resource, File dest, boolean unixStyleNewLines) throws Exception {
        FileUtils.copyResourceToFile(resource, dest, unixStyleNewLines, null);
    }

    public static void copyResourceToFile(String resource, File dest, boolean unixStyleNewLines, File assetsDir) throws Exception {
        FileUtils.copyResourceToFile(resource, dest, assetsDir);
        if (unixStyleNewLines) {
            try {
                FileUtils.processFileContent(dest, c -> c.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
            }
            catch (IOException e) {
                throw new Exception(e.getMessage(), e);
            }
        }
    }

    public static void processFileContent(File dest, Function<String, String> function) throws IOException {
        String content = org.apache.commons.io.FileUtils.readFileToString((File)dest, (Charset)StandardCharsets.UTF_8);
        content = function.apply(content);
        org.apache.commons.io.FileUtils.writeStringToFile((File)dest, (String)content, (Charset)StandardCharsets.UTF_8);
    }

    public static void copyResourceToFile(String resource, File dest) throws Exception {
        FileUtils.copyResourceToFile(resource, dest, null);
    }

    public static void copyResourceToFile(String resource, File dest, File assetsDir) throws Exception {
        if (assetsDir != null) {
            String rsc = resource.startsWith("/") ? resource.substring(1) : resource;
            Path asset = assetsDir.toPath().resolve(rsc);
            if (Files.exists(asset, new LinkOption[0])) {
                Logger.info("Copying resource [" + asset + "] to file [" + dest + "]");
                FileUtils.copyFileToFile(asset.toFile(), dest);
                return;
            }
        }
        Logger.info("Copying resource [" + resource + "] to file [" + dest + "]");
        FileUtils.copyStreamToFile(FileUtils.class.getResourceAsStream(resource), dest);
    }

    public static void createSymlink(File link, File target) throws Exception {
        Logger.info("Creating symbolic link [" + link + "] to [" + target + "]");
        try {
            Files.createSymbolicLink(link.toPath(), target.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Exception("Could not create symlink " + link + " to " + target, e);
        }
    }

    public static void removeFolder(File folder) throws Exception {
        Logger.info("Removing folder [" + folder + "]");
        try {
            if (Platform.windows.isCurrentPlatform()) {
                org.apache.commons.io.FileUtils.deleteDirectory((File)folder);
            } else {
                CommandUtils.execute("rm", "-fr", folder);
            }
        }
        catch (IOException e) {
            throw new Exception("Could not remove folder " + folder, e);
        }
    }

    public static void rename(File file, String newName) {
        Logger.info("Renaming file [" + file + "] to [" + newName + "]");
        file.renameTo(new File(file.getParentFile(), newName));
    }

    public static List<File> findFiles(File searchFolder, String regex) {
        return Arrays.asList(searchFolder.listFiles((dir, name) -> Pattern.matches(regex, name))).stream().map(f -> new File(f.getName())).collect(Collectors.toList());
    }

    public static File findFirstFile(File searchFolder, String regex) {
        return Arrays.asList(searchFolder.listFiles((dir, name) -> Pattern.matches(regex, name))).stream().map(f -> new File(f.getName())).findFirst().orElse(null);
    }

    public static void downloadFromUrl(URL url, File file) throws Exception {
        FileUtils.copyUrlToFile(url, file);
        Logger.info("File downloaded from [" + url + "] to [" + file.getAbsolutePath() + "]");
    }

    public static void downloadFromUrl(String url, File file) throws MalformedURLException, URISyntaxException, Exception {
        FileUtils.downloadFromUrl(new URI(url).toURL(), file);
    }

    public static boolean exists(File file) {
        return file != null && file.exists();
    }

    public static boolean folderContainsFile(File folder, String filename) {
        return new File(folder, filename).exists();
    }

    public static void writeStringToFileWithBOM(File output, String data) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(output);
        byte[] uft8bom = new byte[]{-17, -69, -65};
        fileOutputStream.write(uft8bom);
        fileOutputStream.write(data.getBytes(StandardCharsets.UTF_8));
        fileOutputStream.close();
    }

    public static void copyUrlToFile(URL url, File file) throws Exception {
        FileUtils.copyUrlToFile(url, file, 30000);
    }

    public static void copyUrlToFile(URL url, File file, int timeout) throws Exception {
        HttpURLConnection connection;
        block12: {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            if (connection.getResponseCode() == 200) {
                try (InputStream in = connection.getInputStream();
                     FileOutputStream out = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    break block12;
                }
            }
            Logger.warn("Failed to download the file. Response code: " + connection.getResponseCode());
        }
        connection.disconnect();
    }
}

