/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.utils;

import io.github.fvarrui.javapackager.model.Arch;
import io.github.fvarrui.javapackager.model.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class JDKUtils {
    public static Map<String, String> getRelease(File jdkPath) throws IOException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        File releaseFile = new File(jdkPath, "release");
        if (!releaseFile.exists()) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(releaseFile));
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> propertiesMap.put(key.toString(), value.toString().replaceAll("^\"|\"$", ""))));
        return propertiesMap;
    }

    private static boolean checkPlatform(Platform platform, Map<String, String> releaseMap) {
        try {
            return releaseMap.get("OS_NAME") == null || platform == Platform.getPlatform(releaseMap.get("OS_NAME"));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean checkArchitecture(Arch arch, Map<String, String> releaseMap) {
        try {
            return releaseMap.get("OS_ARCH") == null || arch == null || arch == Arch.getArch(releaseMap.get("OS_ARCH"));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean checkImageType(String imageType, Map<String, String> releaseMap) {
        try {
            return releaseMap.get("IMAGE_TYPE") == null || imageType.equals(releaseMap.get("IMAGE_TYPE"));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidJDK(Platform platform, Arch arch, File jdkPath) throws FileNotFoundException, IOException {
        if (jdkPath == null || !jdkPath.isDirectory()) {
            return false;
        }
        Map<String, String> releaseMap = JDKUtils.getRelease(jdkPath);
        if (releaseMap != null) {
            return JDKUtils.checkPlatform(platform, releaseMap) && JDKUtils.checkArchitecture(arch, releaseMap) && JDKUtils.checkImageType("JDK", releaseMap);
        }
        return true;
    }

    public static boolean isValidJDK(Platform platform, File jdkPath) throws FileNotFoundException, IOException {
        return JDKUtils.isValidJDK(platform, null, jdkPath);
    }

    public static boolean isValidJRE(Platform platform, Arch arch, File jrePath) throws IOException {
        if (jrePath == null || !jrePath.isDirectory()) {
            return false;
        }
        Map<String, String> releaseMap = JDKUtils.getRelease(jrePath);
        if (releaseMap != null) {
            return JDKUtils.checkPlatform(platform, releaseMap) && JDKUtils.checkArchitecture(arch, releaseMap);
        }
        return new File(jrePath, "bin/java").exists() || new File(jrePath, "bin/java.exe").exists();
    }

    public static boolean isValidJRE(Platform platform, File jrePath) throws IOException {
        return JDKUtils.isValidJRE(platform, null, jrePath);
    }

    public static boolean isJDK(File jdkPath) throws IOException {
        Map<String, String> releaseMap = JDKUtils.getRelease(jdkPath);
        if (releaseMap != null) {
            return releaseMap.get("IMAGE_TYPE") == "JDK";
        }
        return true;
    }
}

