/*
 * Decompiled with CFR 0.152.
 */
package qrcode;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import qrcode.QRCode;
import qrcode.QRCodeBuilder;
import qrcode.color.DefaultColorFunction;
import qrcode.color.QRCodeColorFunction;
import qrcode.internals.QRCodeSquare;
import qrcode.raw.ErrorCorrectionLevel;
import qrcode.raw.QRCodeProcessor;
import qrcode.render.QRCodeGraphics;
import qrcode.render.QRCodeGraphicsFactory;
import qrcode.shape.DefaultShapeFunction;
import qrcode.shape.QRCodeShapeFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0001?B\u00a5\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012+\b\u0002\u0010\u000f\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\b\u0013\u0012+\b\u0002\u0010\u0014\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0015J=\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0016\u0010(\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)0)j\u0002`+2\u0006\u00107\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u00108J&\u00109\u001a\u00020\u00112\b\b\u0002\u0010:\u001a\u00020\u00112\b\b\u0002\u00105\u001a\u00020\u00052\b\b\u0002\u00106\u001a\u00020\u0005H\u0007J\u0012\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u00020\u0003H\u0007J\u0006\u0010>\u001a\u00020\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR1\u0010\u0014\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\u000f\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R#\u0010(\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)0)j\u0002`+\u00a2\u0006\n\n\u0002\u0010.\u001a\u0004\b,\u0010-R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001aR\u0011\u00102\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001a\u00a8\u0006@"}, d2={"Lqrcode/QRCode;", "", "data", "", "squareSize", "", "colorFn", "Lqrcode/color/QRCodeColorFunction;", "shapeFn", "Lqrcode/shape/QRCodeShapeFunction;", "graphicsFactory", "Lqrcode/render/QRCodeGraphicsFactory;", "errorCorrectionLevel", "Lqrcode/raw/ErrorCorrectionLevel;", "minTypeNum", "doBefore", "Lkotlin/Function4;", "Lqrcode/render/QRCodeGraphics;", "", "Lkotlin/ExtensionFunctionType;", "doAfter", "(Ljava/lang/String;ILqrcode/color/QRCodeColorFunction;Lqrcode/shape/QRCodeShapeFunction;Lqrcode/render/QRCodeGraphicsFactory;Lqrcode/raw/ErrorCorrectionLevel;ILkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function4;)V", "getColorFn", "()Lqrcode/color/QRCodeColorFunction;", "computedSize", "getComputedSize", "()I", "getData", "()Ljava/lang/String;", "graphics", "getGraphics", "()Lqrcode/render/QRCodeGraphics;", "getGraphicsFactory", "()Lqrcode/render/QRCodeGraphicsFactory;", "setGraphicsFactory", "(Lqrcode/render/QRCodeGraphicsFactory;)V", "qrCodeProcessor", "Lqrcode/raw/QRCodeProcessor;", "getQrCodeProcessor", "()Lqrcode/raw/QRCodeProcessor;", "rawData", "", "Lqrcode/internals/QRCodeSquare;", "Lqrcode/raw/QRCodeRawData;", "getRawData", "()[[Lqrcode/internals/QRCodeSquare;", "[[Lqrcode/internals/QRCodeSquare;", "getShapeFn", "()Lqrcode/shape/QRCodeShapeFunction;", "getSquareSize", "typeNum", "getTypeNum", "draw", "xOffset", "yOffset", "canvas", "(II[[Lqrcode/internals/QRCodeSquare;Lqrcode/render/QRCodeGraphics;)Lqrcode/render/QRCodeGraphics;", "render", "qrCodeGraphics", "renderToBytes", "", "format", "reset", "Companion", "qrcode-kotlin"})
@SourceDebugExtension(value={"SMAP\nQRCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QRCode.kt\nqrcode/QRCode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,179:1\n1#2:180\n13309#3:181\n13309#3,2:182\n13310#3:184\n*S KotlinDebug\n*F\n+ 1 QRCode.kt\nqrcode/QRCode\n*L\n170#1:181\n171#1:182,2\n170#1:184\n*E\n"})
public final class QRCode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String data;
    private final int squareSize;
    @NotNull
    private final QRCodeColorFunction colorFn;
    @NotNull
    private final QRCodeShapeFunction shapeFn;
    @NotNull
    private QRCodeGraphicsFactory graphicsFactory;
    @NotNull
    private final Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit> doBefore;
    @NotNull
    private final Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit> doAfter;
    @NotNull
    private final QRCodeProcessor qrCodeProcessor;
    private final int typeNum;
    @NotNull
    private final QRCodeSquare[][] rawData;
    private final int computedSize;
    @NotNull
    private final QRCodeGraphics graphics;
    @NotNull
    private static final Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit> EMPTY_FN = Companion.EMPTY_FN.1.INSTANCE;
    public static final int DEFAULT_SQUARE_SIZE = 25;

    @JvmOverloads
    public QRCode(@NotNull String data, int squareSize, @NotNull QRCodeColorFunction colorFn, @NotNull QRCodeShapeFunction shapeFn, @NotNull QRCodeGraphicsFactory graphicsFactory, @NotNull ErrorCorrectionLevel errorCorrectionLevel, int minTypeNum, @NotNull Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> doBefore, @NotNull Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> doAfter) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)colorFn, (String)"colorFn");
        Intrinsics.checkNotNullParameter((Object)shapeFn, (String)"shapeFn");
        Intrinsics.checkNotNullParameter((Object)graphicsFactory, (String)"graphicsFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        Intrinsics.checkNotNullParameter(doBefore, (String)"doBefore");
        Intrinsics.checkNotNullParameter(doAfter, (String)"doAfter");
        this.data = data;
        this.squareSize = squareSize;
        this.colorFn = colorFn;
        this.shapeFn = shapeFn;
        this.graphicsFactory = graphicsFactory;
        this.doBefore = doBefore;
        this.doAfter = doAfter;
        this.qrCodeProcessor = new QRCodeProcessor(this.data, ErrorCorrectionLevel.VERY_HIGH, null, this.graphicsFactory, 4, null);
        this.typeNum = RangesKt.coerceAtLeast((int)QRCodeProcessor.Companion.typeForDataAndECL$default(QRCodeProcessor.Companion, this.data, errorCorrectionLevel, null, 4, null), (int)minTypeNum);
        this.rawData = QRCodeProcessor.encode$default(this.qrCodeProcessor, this.typeNum, null, 2, null);
        this.computedSize = this.qrCodeProcessor.computeImageSize(this.squareSize, this.squareSize, this.rawData);
        this.graphics = this.graphicsFactory.newGraphicsSquare(this.computedSize);
    }

    public /* synthetic */ QRCode(String string, int n, QRCodeColorFunction qRCodeColorFunction, QRCodeShapeFunction qRCodeShapeFunction, QRCodeGraphicsFactory qRCodeGraphicsFactory, ErrorCorrectionLevel errorCorrectionLevel, int n2, Function4 function4, Function4 function42, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 25;
        }
        if ((n3 & 4) != 0) {
            qRCodeColorFunction = new DefaultColorFunction(0, 0, 3, null);
        }
        if ((n3 & 8) != 0) {
            qRCodeShapeFunction = new DefaultShapeFunction(n, 0);
        }
        if ((n3 & 0x10) != 0) {
            qRCodeGraphicsFactory = new QRCodeGraphicsFactory();
        }
        if ((n3 & 0x20) != 0) {
            errorCorrectionLevel = ErrorCorrectionLevel.VERY_HIGH;
        }
        if ((n3 & 0x40) != 0) {
            n2 = 6;
        }
        if ((n3 & 0x80) != 0) {
            function4 = EMPTY_FN;
        }
        if ((n3 & 0x100) != 0) {
            function42 = EMPTY_FN;
        }
        this(string, n, qRCodeColorFunction, qRCodeShapeFunction, qRCodeGraphicsFactory, errorCorrectionLevel, n2, function4, function42);
    }

    @NotNull
    public final String getData() {
        return this.data;
    }

    public final int getSquareSize() {
        return this.squareSize;
    }

    @NotNull
    public final QRCodeColorFunction getColorFn() {
        return this.colorFn;
    }

    @NotNull
    public final QRCodeShapeFunction getShapeFn() {
        return this.shapeFn;
    }

    @NotNull
    public final QRCodeGraphicsFactory getGraphicsFactory() {
        return this.graphicsFactory;
    }

    public final void setGraphicsFactory(@NotNull QRCodeGraphicsFactory qRCodeGraphicsFactory) {
        Intrinsics.checkNotNullParameter((Object)qRCodeGraphicsFactory, (String)"<set-?>");
        this.graphicsFactory = qRCodeGraphicsFactory;
    }

    @NotNull
    public final QRCodeProcessor getQrCodeProcessor() {
        return this.qrCodeProcessor;
    }

    public final int getTypeNum() {
        return this.typeNum;
    }

    @NotNull
    public final QRCodeSquare[][] getRawData() {
        return this.rawData;
    }

    public final int getComputedSize() {
        return this.computedSize;
    }

    @NotNull
    public final QRCodeGraphics getGraphics() {
        return this.graphics;
    }

    private final QRCodeGraphics draw(int xOffset, int yOffset, QRCodeSquare[][] rawData, QRCodeGraphics canvas) {
        return this.qrCodeProcessor.renderShaded(this.squareSize, this.squareSize, rawData, canvas, (Function4<? super Integer, ? super Integer, ? super QRCodeSquare, ? super QRCodeGraphics, Unit>)((Function4)new Function4<Integer, Integer, QRCodeSquare, QRCodeGraphics, Unit>(this, xOffset, yOffset, canvas){
            final /* synthetic */ QRCode this$0;
            final /* synthetic */ int $xOffset;
            final /* synthetic */ int $yOffset;
            final /* synthetic */ QRCodeGraphics $canvas;
            {
                this.this$0 = $receiver;
                this.$xOffset = $xOffset;
                this.$yOffset = $yOffset;
                this.$canvas = $canvas;
                super(4);
            }

            public final void invoke(int x, int y, @NotNull QRCodeSquare currentSquare, @NotNull QRCodeGraphics qRCodeGraphics) {
                QRCodeSquare actualSquare;
                Intrinsics.checkNotNullParameter((Object)currentSquare, (String)"currentSquare");
                Intrinsics.checkNotNullParameter((Object)qRCodeGraphics, (String)"<anonymous parameter 3>");
                QRCodeSquare qRCodeSquare = currentSquare.getParent();
                if (qRCodeSquare == null) {
                    qRCodeSquare = currentSquare;
                }
                if (!(actualSquare = qRCodeSquare).getRendered()) {
                    switch (draw.WhenMappings.$EnumSwitchMapping$0[currentSquare.getSquareInfo().getType().ordinal()]) {
                        case 1: 
                        case 2: {
                            this.this$0.getShapeFn().renderControlSquare(this.$xOffset, this.$yOffset, this.this$0.getColorFn(), actualSquare, this.$canvas, this.this$0);
                            break;
                        }
                        default: {
                            this.this$0.getShapeFn().renderSquare(this.$xOffset + x, this.$yOffset + y, this.this$0.getColorFn(), currentSquare, this.$canvas, this.this$0);
                        }
                    }
                    actualSquare.setRendered(true);
                }
            }
        }));
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(@NotNull QRCodeGraphics qrCodeGraphics, int xOffset, int yOffset) {
        QRCodeGraphics qRCodeGraphics;
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        this.colorFn.beforeRender(this, qrCodeGraphics);
        this.shapeFn.beforeRender(this, qrCodeGraphics);
        this.doBefore.invoke((Object)this, (Object)qrCodeGraphics, (Object)xOffset, (Object)yOffset);
        QRCodeGraphics it = qRCodeGraphics = this.draw(xOffset, yOffset, this.rawData, qrCodeGraphics);
        boolean bl = false;
        this.doAfter.invoke((Object)this, (Object)it, (Object)xOffset, (Object)yOffset);
        return qRCodeGraphics;
    }

    public static /* synthetic */ QRCodeGraphics render$default(QRCode qRCode, QRCodeGraphics qRCodeGraphics, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            qRCodeGraphics = qRCode.graphics;
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return qRCode.render(qRCodeGraphics, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final byte[] renderToBytes(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return QRCode.render$default(this, null, 0, 0, 7, null).getBytes(format);
    }

    public static /* synthetic */ byte[] renderToBytes$default(QRCode qRCode, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "PNG";
        }
        return qRCode.renderToBytes(string);
    }

    public final void reset() {
        Object[] $this$forEach$iv = (Object[])this.rawData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QRCodeSquare[] row = (QRCodeSquare[])element$iv;
            boolean bl = false;
            QRCodeSquare[] $this$forEach$iv2 = row;
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                QRCodeSquare element$iv2;
                QRCodeSquare cell = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                cell.setRendered(false);
                QRCodeSquare qRCodeSquare = cell.getParent();
                if (qRCodeSquare == null) continue;
                qRCodeSquare.setRendered(false);
            }
        }
        this.graphics.reset();
    }

    @JvmOverloads
    public QRCode(@NotNull String data, int squareSize, @NotNull QRCodeColorFunction colorFn, @NotNull QRCodeShapeFunction shapeFn, @NotNull QRCodeGraphicsFactory graphicsFactory, @NotNull ErrorCorrectionLevel errorCorrectionLevel, int minTypeNum, @NotNull Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> doBefore) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)colorFn, (String)"colorFn");
        Intrinsics.checkNotNullParameter((Object)shapeFn, (String)"shapeFn");
        Intrinsics.checkNotNullParameter((Object)graphicsFactory, (String)"graphicsFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        Intrinsics.checkNotNullParameter(doBefore, (String)"doBefore");
        this(data, squareSize, colorFn, shapeFn, graphicsFactory, errorCorrectionLevel, minTypeNum, doBefore, null, 256, null);
    }

    @JvmOverloads
    public QRCode(@NotNull String data, int squareSize, @NotNull QRCodeColorFunction colorFn, @NotNull QRCodeShapeFunction shapeFn, @NotNull QRCodeGraphicsFactory graphicsFactory, @NotNull ErrorCorrectionLevel errorCorrectionLevel, int minTypeNum) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)colorFn, (String)"colorFn");
        Intrinsics.checkNotNullParameter((Object)shapeFn, (String)"shapeFn");
        Intrinsics.checkNotNullParameter((Object)graphicsFactory, (String)"graphicsFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        this(data, squareSize, colorFn, shapeFn, graphicsFactory, errorCorrectionLevel, minTypeNum, null, null, 384, null);
    }

    @JvmOverloads
    public QRCode(@NotNull String data, int squareSize, @NotNull QRCodeColorFunction colorFn, @NotNull QRCodeShapeFunction shapeFn, @NotNull QRCodeGraphicsFactory graphicsFactory, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)colorFn, (String)"colorFn");
        Intrinsics.checkNotNullParameter((Object)shapeFn, (String)"shapeFn");
        Intrinsics.checkNotNullParameter((Object)graphicsFactory, (String)"graphicsFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        this(data, squareSize, colorFn, shapeFn, graphicsFactory, errorCorrectionLevel, 0, null, null, 448, null);
    }

    @JvmOverloads
    public QRCode(@NotNull String data, int squareSize, @NotNull QRCodeColorFunction colorFn, @NotNull QRCodeShapeFunction shapeFn, @NotNull QRCodeGraphicsFactory graphicsFactory) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)colorFn, (String)"colorFn");
        Intrinsics.checkNotNullParameter((Object)shapeFn, (String)"shapeFn");
        Intrinsics.checkNotNullParameter((Object)graphicsFactory, (String)"graphicsFactory");
        this(data, squareSize, colorFn, shapeFn, graphicsFactory, null, 0, null, null, 480, null);
    }

    @JvmOverloads
    public QRCode(@NotNull String data, int squareSize, @NotNull QRCodeColorFunction colorFn, @NotNull QRCodeShapeFunction shapeFn) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)colorFn, (String)"colorFn");
        Intrinsics.checkNotNullParameter((Object)shapeFn, (String)"shapeFn");
        this(data, squareSize, colorFn, shapeFn, null, null, 0, null, null, 496, null);
    }

    @JvmOverloads
    public QRCode(@NotNull String data, int squareSize, @NotNull QRCodeColorFunction colorFn) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)colorFn, (String)"colorFn");
        this(data, squareSize, colorFn, null, null, null, 0, null, null, 504, null);
    }

    @JvmOverloads
    public QRCode(@NotNull String data, int squareSize) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data, squareSize, null, null, null, null, 0, null, null, 508, null);
    }

    @JvmOverloads
    public QRCode(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data, 0, null, null, null, null, 0, null, null, 510, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(@NotNull QRCodeGraphics qrCodeGraphics, int xOffset) {
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        return QRCode.render$default(this, qrCodeGraphics, xOffset, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(@NotNull QRCodeGraphics qrCodeGraphics) {
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        return QRCode.render$default(this, qrCodeGraphics, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render() {
        return QRCode.render$default(this, null, 0, 0, 7, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] renderToBytes() {
        return QRCode.renderToBytes$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final QRCodeBuilder ofSquares() {
        return Companion.ofSquares();
    }

    @JvmStatic
    @NotNull
    public static final QRCodeBuilder ofCircles() {
        return Companion.ofCircles();
    }

    @JvmStatic
    @NotNull
    public static final QRCodeBuilder ofRoundedSquares() {
        return Companion.ofRoundedSquares();
    }

    @JvmStatic
    @NotNull
    public static final QRCodeBuilder ofCustomShape(@NotNull QRCodeShapeFunction customShapeFunction) {
        return Companion.ofCustomShape(customShapeFunction);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R7\u0010\u0005\u001a%\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\b\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lqrcode/QRCode$Companion;", "", "()V", "DEFAULT_SQUARE_SIZE", "", "EMPTY_FN", "Lkotlin/Function4;", "Lqrcode/QRCode;", "Lqrcode/render/QRCodeGraphics;", "", "Lkotlin/ExtensionFunctionType;", "getEMPTY_FN$qrcode_kotlin", "()Lkotlin/jvm/functions/Function4;", "ofCircles", "Lqrcode/QRCodeBuilder;", "ofCustomShape", "customShapeFunction", "Lqrcode/shape/QRCodeShapeFunction;", "ofRoundedSquares", "ofSquares", "qrcode-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit> getEMPTY_FN$qrcode_kotlin() {
            return EMPTY_FN;
        }

        @JvmStatic
        @NotNull
        public final QRCodeBuilder ofSquares() {
            return new QRCodeBuilder(QRCodeBuilder.QRCodeShapesEnum.SQUARE, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final QRCodeBuilder ofCircles() {
            return new QRCodeBuilder(QRCodeBuilder.QRCodeShapesEnum.CIRCLE, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final QRCodeBuilder ofRoundedSquares() {
            return new QRCodeBuilder(QRCodeBuilder.QRCodeShapesEnum.ROUNDED_SQUARE, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final QRCodeBuilder ofCustomShape(@NotNull QRCodeShapeFunction customShapeFunction) {
            Intrinsics.checkNotNullParameter((Object)customShapeFunction, (String)"customShapeFunction");
            return new QRCodeBuilder(QRCodeBuilder.QRCodeShapesEnum.CUSTOM, customShapeFunction);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

