/*
 * Decompiled with CFR 0.152.
 */
package qrcode;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qrcode.QRCode;
import qrcode.color.DefaultColorFunction;
import qrcode.color.LinearGradientColorFunction;
import qrcode.color.QRCodeColorFunction;
import qrcode.internals.QRCodeSquare;
import qrcode.internals.QRMath;
import qrcode.raw.ErrorCorrectionLevel;
import qrcode.render.QRCodeGraphics;
import qrcode.render.QRCodeGraphicsFactory;
import qrcode.shape.CircleShapeFunction;
import qrcode.shape.DefaultShapeFunction;
import qrcode.shape.QRCodeShapeFunction;
import qrcode.shape.RoundSquaresShapeFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0012\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0001OB\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.J\b\u0010!\u001a\u00020\u000bH\u0002J%\u0010/\u001a\u00020\u00002\u001d\u00100\u001a\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f01\u00a2\u0006\u0002\b\rJ\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u000bJ%\u00104\u001a\u00020\u00002\u001d\u00100\u001a\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f01\u00a2\u0006\u0002\b\rJ\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000bJ\u0010\u00106\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u00010\u0015J\u0010\u00108\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u0005J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u001eJ)\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010*\u001a\u00020+H\u0007\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020 J\u0019\u0010A\u001a\u00020\u00002\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\u0010CJ,\u0010D\u001a\u00020\u00002\b\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020\u000b2\u0006\u0010H\u001a\u00020\u000b2\b\b\u0002\u0010I\u001a\u00020+H\u0007J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000bJ\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u000bJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u000bR7\u0010\u0007\u001a%\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R7\u0010\u0011\u001a%\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u0019\u001a%\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u001a\u001a%\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010(\u001a%\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010)\u001a%\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lqrcode/QRCodeBuilder;", "", "shape", "Lqrcode/QRCodeBuilder$QRCodeShapesEnum;", "customShapeFunction", "Lqrcode/shape/QRCodeShapeFunction;", "(Lqrcode/QRCodeBuilder$QRCodeShapesEnum;Lqrcode/shape/QRCodeShapeFunction;)V", "afterFn", "Lkotlin/Function4;", "Lqrcode/QRCode;", "Lqrcode/render/QRCodeGraphics;", "", "", "Lkotlin/ExtensionFunctionType;", "getAfterFn", "()Lkotlin/jvm/functions/Function4;", "background", "beforeFn", "getBeforeFn", "color", "colorFunction", "Lqrcode/color/QRCodeColorFunction;", "getColorFunction", "()Lqrcode/color/QRCodeColorFunction;", "customColorFunction", "drawLogoAction", "drawLogoBeforeAction", "endColor", "Ljava/lang/Integer;", "errorCorrectionLevel", "Lqrcode/raw/ErrorCorrectionLevel;", "graphicsFactory", "Lqrcode/render/QRCodeGraphicsFactory;", "innerSpace", "minTypeNum", "radiusInPixels", "shapeFunction", "getShapeFunction", "()Lqrcode/shape/QRCodeShapeFunction;", "squareSize", "userDoAfter", "userDoBefore", "vertical", "", "build", "data", "", "withAfterRenderAction", "action", "Lkotlin/Function2;", "withBackgroundColor", "bgColor", "withBeforeRenderAction", "withColor", "withCustomColorFunction", "colorFn", "withCustomShapeFunction", "shapeFn", "withErrorCorrectionLevel", "ecl", "withGradientColor", "startColor", "(ILjava/lang/Integer;Z)Lqrcode/QRCodeBuilder;", "withGraphicsFactory", "factory", "withInnerSpacing", "innerSpacing", "(Ljava/lang/Integer;)Lqrcode/QRCodeBuilder;", "withLogo", "logo", "", "width", "height", "clearLogoArea", "withMinimumInformationDensity", "withRadius", "radius", "withSize", "size", "QRCodeShapesEnum", "qrcode-kotlin"})
@SourceDebugExtension(value={"SMAP\nQRCodeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QRCodeBuilder.kt\nqrcode/QRCodeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
public final class QRCodeBuilder {
    @NotNull
    private final QRCodeShapesEnum shape;
    @Nullable
    private QRCodeShapeFunction customShapeFunction;
    @Nullable
    private QRCodeColorFunction customColorFunction;
    private int squareSize;
    private int color;
    @Nullable
    private Integer endColor;
    private boolean vertical;
    private int background;
    private int innerSpace;
    private int radiusInPixels;
    @NotNull
    private Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> drawLogoAction;
    @NotNull
    private Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> drawLogoBeforeAction;
    @NotNull
    private Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> userDoAfter;
    @NotNull
    private Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> userDoBefore;
    @NotNull
    private QRCodeGraphicsFactory graphicsFactory;
    @NotNull
    private ErrorCorrectionLevel errorCorrectionLevel;
    private int minTypeNum;

    @JvmOverloads
    public QRCodeBuilder(@NotNull QRCodeShapesEnum shape, @Nullable QRCodeShapeFunction customShapeFunction) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        this.shape = shape;
        this.customShapeFunction = customShapeFunction;
        this.squareSize = 25;
        this.color = -16777216;
        this.vertical = true;
        this.background = -1;
        this.innerSpace = this.innerSpace();
        this.radiusInPixels = RoundSquaresShapeFunction.Companion.defaultRadius(this.squareSize);
        this.drawLogoAction = QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
        this.drawLogoBeforeAction = QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
        this.userDoAfter = QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
        this.userDoBefore = QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
        this.graphicsFactory = new QRCodeGraphicsFactory();
        this.errorCorrectionLevel = ErrorCorrectionLevel.VERY_HIGH;
        this.minTypeNum = 6;
    }

    public /* synthetic */ QRCodeBuilder(QRCodeShapesEnum qRCodeShapesEnum, QRCodeShapeFunction qRCodeShapeFunction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            qRCodeShapeFunction = null;
        }
        this(qRCodeShapesEnum, qRCodeShapeFunction);
    }

    private final int innerSpace() {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[this.shape.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = CircleShapeFunction.Companion.defaultInnerSpace(this.squareSize);
                break;
            }
            case 3: {
                n = RoundSquaresShapeFunction.Companion.defaultInnerSpace(this.squareSize);
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it < this.squareSize ? n2 : null;
        return n3 != null ? n3 : 0;
    }

    @NotNull
    public final QRCodeBuilder withSize(int size) {
        this.squareSize = RangesKt.coerceAtLeast((int)size, (int)1);
        return this.withInnerSpacing(this.innerSpace());
    }

    @NotNull
    public final QRCodeBuilder withColor(int color) {
        this.color = color;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withBackgroundColor(int bgColor) {
        this.background = bgColor;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withGradientColor(int startColor, @Nullable Integer endColor, boolean vertical) {
        this.color = startColor;
        this.endColor = endColor;
        this.vertical = vertical;
        return this;
    }

    public static /* synthetic */ QRCodeBuilder withGradientColor$default(QRCodeBuilder qRCodeBuilder, int n, Integer n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        return qRCodeBuilder.withGradientColor(n, n2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QRCodeBuilder withRadius(int radius) {
        void it;
        Integer n = radius;
        int n2 = ((Number)n).intValue();
        QRCodeBuilder qRCodeBuilder = this;
        boolean bl = false;
        boolean bl2 = it >= 0;
        Integer n3 = bl2 ? n : null;
        qRCodeBuilder.radiusInPixels = n3 != null ? n3.intValue() : RoundSquaresShapeFunction.Companion.defaultRadius(this.squareSize);
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withInnerSpacing(@Nullable Integer innerSpacing) {
        v0 = this;
        v1 = innerSpacing;
        if (v1 == null) ** GOTO lbl-1000
        var2_2 = v1;
        var3_3 = ((Number)var2_2).intValue();
        var5_4 = v0;
        $i$a$-takeIf-QRCodeBuilder$withInnerSpacing$1 = false;
        var6_6 = it >= 0;
        v0 = var5_4;
        v1 = var6_6 != false ? var2_2 : null;
        if (v1 != null) {
            v2 = v1;
        } else lbl-1000:
        // 2 sources

        {
            v2 = this.innerSpace();
        }
        v0.innerSpace = v2;
        return this;
    }

    public static /* synthetic */ QRCodeBuilder withInnerSpacing$default(QRCodeBuilder qRCodeBuilder, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return qRCodeBuilder.withInnerSpacing(n);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withLogo(@Nullable byte[] logo, int width, int height, boolean clearLogoArea) {
        if (logo != null) {
            this.drawLogoBeforeAction = clearLogoArea ? (Function4)new Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit>(width, height){
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                {
                    this.$width = $width;
                    this.$height = $height;
                    super(4);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull QRCode $this$null, @NotNull QRCodeGraphics qRCodeGraphics, int n, int n2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                    Intrinsics.checkNotNullParameter((Object)qRCodeGraphics, (String)"<anonymous parameter 0>");
                    int logoX = ($this$null.getComputedSize() - this.$width) / 2;
                    int logoY = ($this$null.getComputedSize() - this.$height) / 2;
                    Object[] objectArray = (Object[])$this$null.getRawData();
                    int n3 = this.$width;
                    int n4 = this.$height;
                    boolean $i$f$forEach = false;
                    for (void element$iv : $this$forEach$iv) {
                        QRCodeSquare[] row = (QRCodeSquare[])element$iv;
                        boolean bl = false;
                        QRCodeSquare[] $this$forEach$iv2 = row;
                        boolean $i$f$forEach2 = false;
                        int n5 = $this$forEach$iv2.length;
                        for (int i = 0; i < n5; ++i) {
                            int cellY;
                            QRCodeSquare element$iv2;
                            QRCodeSquare cell = element$iv2 = $this$forEach$iv2[i];
                            boolean bl2 = false;
                            int cellX = cell.absoluteX($this$null.getSquareSize()) + $this$null.getSquareSize();
                            cell.setRendered(!QRMath.INSTANCE.rectsIntersect(logoX, logoY, n3, n4, cellX, cellY = cell.absoluteY($this$null.getSquareSize()) + $this$null.getSquareSize(), $this$null.getSquareSize(), $this$null.getSquareSize()));
                        }
                    }
                }
            } : QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
            this.drawLogoAction = (Function4)new Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit>(width, height, logo){
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ byte[] $logo;
                {
                    this.$width = $width;
                    this.$height = $height;
                    this.$logo = $logo;
                    super(4);
                }

                public final void invoke(@NotNull QRCode $this$null, @NotNull QRCodeGraphics canvas, int xOffset, int yOffset) {
                    Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                    Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                    int logoX = xOffset + ($this$null.getComputedSize() - this.$width) / 2;
                    int logoY = yOffset + ($this$null.getComputedSize() - this.$height) / 2;
                    canvas.drawImage(this.$logo, logoX, logoY);
                }
            };
        }
        return this;
    }

    public static /* synthetic */ QRCodeBuilder withLogo$default(QRCodeBuilder qRCodeBuilder, byte[] byArray, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return qRCodeBuilder.withLogo(byArray, n, n2, bl);
    }

    @NotNull
    public final QRCodeBuilder withAfterRenderAction(@NotNull Function2<? super QRCode, ? super QRCodeGraphics, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.userDoAfter = (Function4)new Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit>(action){
            final /* synthetic */ Function2<QRCode, QRCodeGraphics, Unit> $action;
            {
                this.$action = $action;
                super(4);
            }

            public final void invoke(@NotNull QRCode $this$null, @NotNull QRCodeGraphics it, int n, int n2) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$action.invoke((Object)$this$null, (Object)it);
            }
        };
        return this;
    }

    @NotNull
    public final QRCodeBuilder withBeforeRenderAction(@NotNull Function2<? super QRCode, ? super QRCodeGraphics, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.userDoBefore = (Function4)new Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit>(action){
            final /* synthetic */ Function2<QRCode, QRCodeGraphics, Unit> $action;
            {
                this.$action = $action;
                super(4);
            }

            public final void invoke(@NotNull QRCode $this$null, @NotNull QRCodeGraphics it, int n, int n2) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$action.invoke((Object)$this$null, (Object)it);
            }
        };
        return this;
    }

    @NotNull
    public final QRCodeBuilder withGraphicsFactory(@NotNull QRCodeGraphicsFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.graphicsFactory = factory;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withCustomColorFunction(@Nullable QRCodeColorFunction colorFn) {
        this.customColorFunction = colorFn;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withCustomShapeFunction(@Nullable QRCodeShapeFunction shapeFn) {
        this.customShapeFunction = shapeFn;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withErrorCorrectionLevel(@NotNull ErrorCorrectionLevel ecl) {
        Intrinsics.checkNotNullParameter((Object)((Object)ecl), (String)"ecl");
        this.errorCorrectionLevel = ecl;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withMinimumInformationDensity(int minTypeNum) {
        this.minTypeNum = minTypeNum;
        return this;
    }

    private final Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit> getBeforeFn() {
        return (Function4)new Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit>(this){
            final /* synthetic */ QRCodeBuilder this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            public final void invoke(@NotNull QRCode $this$null, @NotNull QRCodeGraphics canvas, int xOffset, int yOffset) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                QRCodeBuilder.access$getDrawLogoBeforeAction$p(this.this$0).invoke((Object)$this$null, (Object)canvas, (Object)xOffset, (Object)yOffset);
                QRCodeBuilder.access$getUserDoBefore$p(this.this$0).invoke((Object)$this$null, (Object)canvas, (Object)xOffset, (Object)yOffset);
            }
        };
    }

    private final Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit> getAfterFn() {
        return (Function4)new Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit>(this){
            final /* synthetic */ QRCodeBuilder this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            public final void invoke(@NotNull QRCode $this$null, @NotNull QRCodeGraphics canvas, int xOffset, int yOffset) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                QRCodeBuilder.access$getDrawLogoAction$p(this.this$0).invoke((Object)$this$null, (Object)canvas, (Object)xOffset, (Object)yOffset);
                QRCodeBuilder.access$getUserDoAfter$p(this.this$0).invoke((Object)$this$null, (Object)canvas, (Object)xOffset, (Object)yOffset);
            }
        };
    }

    private final QRCodeColorFunction getColorFunction() {
        QRCodeColorFunction qRCodeColorFunction;
        if (this.endColor == null) {
            qRCodeColorFunction = this.customColorFunction;
            if (qRCodeColorFunction == null) {
                qRCodeColorFunction = new DefaultColorFunction(this.color, this.background);
            }
        } else {
            qRCodeColorFunction = this.customColorFunction;
            if (qRCodeColorFunction == null) {
                Integer n = this.endColor;
                Intrinsics.checkNotNull((Object)n);
                qRCodeColorFunction = new LinearGradientColorFunction(this.color, n, this.background, false, 8, null);
            }
        }
        return qRCodeColorFunction;
    }

    private final QRCodeShapeFunction getShapeFunction() {
        QRCodeShapeFunction qRCodeShapeFunction = this.customShapeFunction;
        if (qRCodeShapeFunction == null) {
            DefaultShapeFunction defaultShapeFunction;
            switch (WhenMappings.$EnumSwitchMapping$0[this.shape.ordinal()]) {
                case 1: 
                case 4: {
                    defaultShapeFunction = new DefaultShapeFunction(this.squareSize, this.innerSpace);
                    break;
                }
                case 2: {
                    defaultShapeFunction = new CircleShapeFunction(this.squareSize, this.innerSpace);
                    break;
                }
                case 3: {
                    defaultShapeFunction = new RoundSquaresShapeFunction(this.squareSize, this.radiusInPixels, this.innerSpace);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            qRCodeShapeFunction = defaultShapeFunction;
        }
        return qRCodeShapeFunction;
    }

    @NotNull
    public final QRCode build(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new QRCode(data, this.squareSize, this.getColorFunction(), this.getShapeFunction(), this.graphicsFactory, this.errorCorrectionLevel, this.minTypeNum, this.getBeforeFn(), this.getAfterFn());
    }

    @JvmOverloads
    public QRCodeBuilder(@NotNull QRCodeShapesEnum shape) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        this(shape, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withGradientColor(int startColor, @Nullable Integer endColor) {
        return QRCodeBuilder.withGradientColor$default(this, startColor, endColor, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withInnerSpacing() {
        return QRCodeBuilder.withInnerSpacing$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withLogo(@Nullable byte[] logo, int width, int height) {
        return QRCodeBuilder.withLogo$default(this, logo, width, height, false, 8, null);
    }

    public static final /* synthetic */ Function4 access$getDrawLogoBeforeAction$p(QRCodeBuilder $this) {
        return $this.drawLogoBeforeAction;
    }

    public static final /* synthetic */ Function4 access$getUserDoBefore$p(QRCodeBuilder $this) {
        return $this.userDoBefore;
    }

    public static final /* synthetic */ Function4 access$getDrawLogoAction$p(QRCodeBuilder $this) {
        return $this.drawLogoAction;
    }

    public static final /* synthetic */ Function4 access$getUserDoAfter$p(QRCodeBuilder $this) {
        return $this.userDoAfter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lqrcode/QRCodeBuilder$QRCodeShapesEnum;", "", "(Ljava/lang/String;I)V", "SQUARE", "CIRCLE", "ROUNDED_SQUARE", "CUSTOM", "qrcode-kotlin"})
    public static final class QRCodeShapesEnum
    extends Enum<QRCodeShapesEnum> {
        public static final /* enum */ QRCodeShapesEnum SQUARE = new QRCodeShapesEnum();
        public static final /* enum */ QRCodeShapesEnum CIRCLE = new QRCodeShapesEnum();
        public static final /* enum */ QRCodeShapesEnum ROUNDED_SQUARE = new QRCodeShapesEnum();
        public static final /* enum */ QRCodeShapesEnum CUSTOM = new QRCodeShapesEnum();
        private static final /* synthetic */ QRCodeShapesEnum[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static QRCodeShapesEnum[] values() {
            return (QRCodeShapesEnum[])$VALUES.clone();
        }

        public static QRCodeShapesEnum valueOf(String value) {
            return Enum.valueOf(QRCodeShapesEnum.class, value);
        }

        @NotNull
        public static EnumEntries<QRCodeShapesEnum> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = qRCodeShapesEnumArray = new QRCodeShapesEnum[]{QRCodeShapesEnum.SQUARE, QRCodeShapesEnum.CIRCLE, QRCodeShapesEnum.ROUNDED_SQUARE, QRCodeShapesEnum.CUSTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QRCodeShapesEnum.values().length];
            try {
                nArray[QRCodeShapesEnum.SQUARE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeShapesEnum.CIRCLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeShapesEnum.ROUNDED_SQUARE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeShapesEnum.CUSTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

