/*
 * Decompiled with CFR 0.152.
 */
package qrcode.internals;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import qrcode.internals.BitBuffer;
import qrcode.internals.QRData;
import qrcode.raw.QRCodeDataType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lqrcode/internals/QR8BitByte;", "Lqrcode/internals/QRData;", "data", "", "(Ljava/lang/String;)V", "dataBytes", "", "length", "", "write", "", "buffer", "Lqrcode/internals/BitBuffer;", "qrcode-kotlin"})
public final class QR8BitByte
extends QRData {
    @NotNull
    private final byte[] dataBytes;

    public QR8BitByte(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(QRCodeDataType.DEFAULT, data);
        this.dataBytes = StringsKt.encodeToByteArray((String)data);
    }

    @Override
    public void write(@NotNull BitBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int n = this.dataBytes.length;
        for (int i = 0; i < n; ++i) {
            buffer.put(this.dataBytes[i], 8);
        }
    }

    @Override
    public int length() {
        return this.dataBytes.length;
    }
}

