/*
 * Decompiled with CFR 0.152.
 */
package qrcode.internals;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import qrcode.internals.BitBuffer;
import qrcode.internals.QRData;
import qrcode.raw.QRCodeDataType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lqrcode/internals/QRAlphaNum;", "Lqrcode/internals/QRData;", "data", "", "(Ljava/lang/String;)V", "charCode", "", "c", "", "length", "write", "", "buffer", "Lqrcode/internals/BitBuffer;", "qrcode-kotlin"})
public final class QRAlphaNum
extends QRData {
    public QRAlphaNum(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(QRCodeDataType.UPPER_ALPHA_NUM, data);
    }

    @Override
    public void write(@NotNull BitBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int i = 0;
        int dataLength = this.getData().length();
        while (i + 1 < dataLength) {
            buffer.put(this.charCode(this.getData().charAt(i)) * 45 + this.charCode(this.getData().charAt(i + 1)), 11);
            i += 2;
        }
        if (i < dataLength) {
            buffer.put(this.charCode(this.getData().charAt(i)), 6);
        }
    }

    @Override
    public int length() {
        return this.getData().length();
    }

    private final int charCode(char c) {
        int n;
        char c2 = c;
        boolean bl = '0' <= c2 ? c2 < ':' : false;
        if (bl) {
            n = c - 48;
        } else {
            boolean bl2 = 'A' <= c2 ? c2 < '[' : false;
            if (bl2) {
                n = c - 65 + 10;
            } else {
                char c3 = c;
                if (c3 == ' ') {
                    n = 36;
                } else if (c3 == '$') {
                    n = 37;
                } else if (c3 == '%') {
                    n = 38;
                } else if (c3 == '*') {
                    n = 39;
                } else if (c3 == '+') {
                    n = 40;
                } else if (c3 == '-') {
                    n = 41;
                } else if (c3 == '.') {
                    n = 42;
                } else if (c3 == '/') {
                    n = 43;
                } else if (c3 == ':') {
                    n = 44;
                } else {
                    throw new IllegalArgumentException("Illegal character: " + c);
                }
            }
        }
        return n;
    }
}

