/*
 * Decompiled with CFR 0.152.
 */
package qrcode.raw;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import qrcode.internals.BitBuffer;
import qrcode.internals.Polynomial;
import qrcode.internals.QR8BitByte;
import qrcode.internals.QRAlphaNum;
import qrcode.internals.QRCodeSetup;
import qrcode.internals.QRCodeSquare;
import qrcode.internals.QRCodeSquareInfo;
import qrcode.internals.QRCodeSquareType;
import qrcode.internals.QRData;
import qrcode.internals.QRNumber;
import qrcode.internals.QRUtil;
import qrcode.internals.RSBlock;
import qrcode.raw.ErrorCorrectionLevel;
import qrcode.raw.MaskPattern;
import qrcode.raw.QRCodeDataType;
import qrcode.render.QRCodeGraphics;
import qrcode.render.QRCodeGraphicsFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 32\u00020\u0001:\u00013B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010J;\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00102\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0015j\u0002`\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0010H\u0002J1\u0010\"\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0015j\u0002`\u00172\b\b\u0002\u0010!\u001a\u00020\u00102\b\b\u0002\u0010#\u001a\u00020$H\u0007\u00a2\u0006\u0002\u0010%J8\u0010&\u001a\u00020'2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00102\b\b\u0002\u0010(\u001a\u00020\u00102\b\b\u0002\u0010)\u001a\u00020\u00102\b\b\u0002\u0010*\u001a\u00020\u0010Jc\u0010&\u001a\u00020'2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00102\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0015j\u0002`\u00172\b\b\u0002\u0010+\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u00102\b\b\u0002\u0010)\u001a\u00020\u00102\b\b\u0002\u0010*\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010,Jk\u0010-\u001a\u00020'2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00102\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0015j\u0002`\u00172\b\b\u0002\u0010+\u001a\u00020'2$\u0010.\u001a \u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002000/H\u0007\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lqrcode/raw/QRCodeProcessor;", "", "data", "", "errorCorrectionLevel", "Lqrcode/raw/ErrorCorrectionLevel;", "dataType", "Lqrcode/raw/QRCodeDataType;", "graphicsFactory", "Lqrcode/render/QRCodeGraphicsFactory;", "(Ljava/lang/String;Lqrcode/raw/ErrorCorrectionLevel;Lqrcode/raw/QRCodeDataType;Lqrcode/render/QRCodeGraphicsFactory;)V", "getGraphicsFactory", "()Lqrcode/render/QRCodeGraphicsFactory;", "qrCodeData", "Lqrcode/internals/QRData;", "computeImageSize", "", "cellSize", "margin", "size", "rawData", "", "Lqrcode/internals/QRCodeSquare;", "Lqrcode/raw/QRCodeRawData;", "(II[[Lqrcode/internals/QRCodeSquare;)I", "createBytes", "", "buffer", "Lqrcode/internals/BitBuffer;", "rsBlocks", "Lqrcode/internals/RSBlock;", "(Lqrcode/internals/BitBuffer;[Lqrcode/internals/RSBlock;)[I", "createData", "type", "encode", "maskPattern", "Lqrcode/raw/MaskPattern;", "(ILqrcode/raw/MaskPattern;)[[Lqrcode/internals/QRCodeSquare;", "render", "Lqrcode/render/QRCodeGraphics;", "brightColor", "darkColor", "marginColor", "qrCodeGraphics", "(II[[Lqrcode/internals/QRCodeSquare;Lqrcode/render/QRCodeGraphics;III)Lqrcode/render/QRCodeGraphics;", "renderShaded", "renderer", "Lkotlin/Function4;", "", "(II[[Lqrcode/internals/QRCodeSquare;Lqrcode/render/QRCodeGraphics;Lkotlin/jvm/functions/Function4;)Lqrcode/render/QRCodeGraphics;", "toString", "Companion", "qrcode-kotlin"})
@SourceDebugExtension(value={"SMAP\nQRCodeProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QRCodeProcessor.kt\nqrcode/raw/QRCodeProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,448:1\n13309#2:449\n13309#2,2:450\n13310#2:452\n13374#2,3:454\n1#3:453\n*S KotlinDebug\n*F\n+ 1 QRCodeProcessor.kt\nqrcode/raw/QRCodeProcessor\n*L\n287#1:449\n288#1:450,2\n287#1:452\n395#1:454,3\n*E\n"})
public final class QRCodeProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String data;
    @NotNull
    private final ErrorCorrectionLevel errorCorrectionLevel;
    @NotNull
    private final QRCodeDataType dataType;
    @NotNull
    private final QRCodeGraphicsFactory graphicsFactory;
    @NotNull
    private final QRData qrCodeData;
    public static final int DEFAULT_CELL_SIZE = 25;
    public static final int DEFAULT_MARGIN = 0;
    private static final int PAD0 = 236;
    private static final int PAD1 = 17;

    @JvmOverloads
    public QRCodeProcessor(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel, @NotNull QRCodeDataType dataType, @NotNull QRCodeGraphicsFactory graphicsFactory) {
        QRData qRData;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        Intrinsics.checkNotNullParameter((Object)graphicsFactory, (String)"graphicsFactory");
        this.data = data;
        this.errorCorrectionLevel = errorCorrectionLevel;
        this.dataType = dataType;
        this.graphicsFactory = graphicsFactory;
        switch (WhenMappings.$EnumSwitchMapping$0[this.dataType.ordinal()]) {
            case 1: {
                qRData = new QRNumber(this.data);
                break;
            }
            case 2: {
                qRData = new QRAlphaNum(this.data);
                break;
            }
            case 3: {
                qRData = new QR8BitByte(this.data);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.qrCodeData = qRData;
    }

    public /* synthetic */ QRCodeProcessor(String string, ErrorCorrectionLevel errorCorrectionLevel, QRCodeDataType qRCodeDataType, QRCodeGraphicsFactory qRCodeGraphicsFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            errorCorrectionLevel = ErrorCorrectionLevel.MEDIUM;
        }
        if ((n & 4) != 0) {
            qRCodeDataType = QRUtil.INSTANCE.getDataType(string);
        }
        if ((n & 8) != 0) {
            qRCodeGraphicsFactory = new QRCodeGraphicsFactory();
        }
        this(string, errorCorrectionLevel, qRCodeDataType, qRCodeGraphicsFactory);
    }

    @NotNull
    public final QRCodeGraphicsFactory getGraphicsFactory() {
        return this.graphicsFactory;
    }

    public final int computeImageSize(int cellSize, int margin, @NotNull QRCodeSquare[][] rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        return this.computeImageSize(cellSize, margin, ((Object[])rawData).length);
    }

    public static /* synthetic */ int computeImageSize$default(QRCodeProcessor qRCodeProcessor, int n, int n2, QRCodeSquare[][] qRCodeSquareArray, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 25;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            qRCodeSquareArray = QRCodeProcessor.encode$default(qRCodeProcessor, 0, null, 3, null);
        }
        return qRCodeProcessor.computeImageSize(n, n2, qRCodeSquareArray);
    }

    public final int computeImageSize(int cellSize, int margin, int size) {
        return size * cellSize + margin * 2;
    }

    public static /* synthetic */ int computeImageSize$default(QRCodeProcessor qRCodeProcessor, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 25;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        return qRCodeProcessor.computeImageSize(n, n2, n3);
    }

    @NotNull
    public final QRCodeGraphics render(int cellSize, int margin, int brightColor, int darkColor, int marginColor) {
        return QRCodeProcessor.render$default(this, cellSize, margin, QRCodeProcessor.encode$default(this, 0, null, 3, null), null, brightColor, darkColor, marginColor, 8, null);
    }

    public static /* synthetic */ QRCodeGraphics render$default(QRCodeProcessor qRCodeProcessor, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = 25;
        }
        if ((n6 & 2) != 0) {
            n2 = 0;
        }
        if ((n6 & 4) != 0) {
            n3 = -1;
        }
        if ((n6 & 8) != 0) {
            n4 = -16777216;
        }
        if ((n6 & 0x10) != 0) {
            n5 = -1;
        }
        return qRCodeProcessor.render(n, n2, n3, n4, n5);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(int cellSize, int margin, @NotNull QRCodeSquare[][] rawData, @NotNull QRCodeGraphics qrCodeGraphics, int brightColor, int darkColor, int marginColor) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        return this.renderShaded(cellSize, margin, rawData, qrCodeGraphics, (Function4<? super Integer, ? super Integer, ? super QRCodeSquare, ? super QRCodeGraphics, Unit>)((Function4)new Function4<Integer, Integer, QRCodeSquare, QRCodeGraphics, Unit>(cellSize, darkColor, brightColor, margin, marginColor){
            final /* synthetic */ int $cellSize;
            final /* synthetic */ int $darkColor;
            final /* synthetic */ int $brightColor;
            final /* synthetic */ int $margin;
            final /* synthetic */ int $marginColor;
            {
                this.$cellSize = $cellSize;
                this.$darkColor = $darkColor;
                this.$brightColor = $brightColor;
                this.$margin = $margin;
                this.$marginColor = $marginColor;
                super(4);
            }

            public final void invoke(int x, int y, @NotNull QRCodeSquare cellData, @NotNull QRCodeGraphics graphics) {
                Intrinsics.checkNotNullParameter((Object)cellData, (String)"cellData");
                Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
                if (cellData.getSquareInfo().getType() != QRCodeSquareType.MARGIN) {
                    if (cellData.getDark()) {
                        graphics.fillRect(x, y, this.$cellSize, this.$cellSize, this.$darkColor);
                    } else {
                        graphics.fillRect(x, y, this.$cellSize, this.$cellSize, this.$brightColor);
                    }
                } else {
                    graphics.fillRect(x, y, this.$margin, this.$margin, this.$marginColor);
                }
            }
        }));
    }

    public static /* synthetic */ QRCodeGraphics render$default(QRCodeProcessor qRCodeProcessor, int n, int n2, QRCodeSquare[][] qRCodeSquareArray, QRCodeGraphics qRCodeGraphics, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = 25;
        }
        if ((n6 & 2) != 0) {
            n2 = 0;
        }
        if ((n6 & 4) != 0) {
            qRCodeSquareArray = QRCodeProcessor.encode$default(qRCodeProcessor, 0, null, 3, null);
        }
        if ((n6 & 8) != 0) {
            qRCodeGraphics = qRCodeProcessor.graphicsFactory.newGraphicsSquare(qRCodeProcessor.computeImageSize(n, n2, qRCodeSquareArray));
        }
        if ((n6 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n6 & 0x20) != 0) {
            n4 = -16777216;
        }
        if ((n6 & 0x40) != 0) {
            n5 = -1;
        }
        return qRCodeProcessor.render(n, n2, qRCodeSquareArray, qRCodeGraphics, n3, n4, n5);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics renderShaded(int cellSize, int margin, @NotNull QRCodeSquare[][] rawData, @NotNull QRCodeGraphics qrCodeGraphics, @NotNull Function4<? super Integer, ? super Integer, ? super QRCodeSquare, ? super QRCodeGraphics, Unit> renderer) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        if (margin > 0) {
            QRCodeSquare marginSquare = new QRCodeSquare(false, 0, 0, ((Object[])rawData).length, QRCodeSquareInfo.Companion.margin$qrcode_kotlin(), 0, 0, null, 224, null);
            renderer.invoke((Object)marginSquare.absoluteX(margin), (Object)marginSquare.absoluteY(margin), (Object)marginSquare, (Object)qrCodeGraphics);
        }
        Object[] $this$forEach$iv = (Object[])rawData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QRCodeSquare[] rowData = (QRCodeSquare[])element$iv;
            boolean bl = false;
            QRCodeSquare[] $this$forEach$iv2 = rowData;
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                QRCodeSquare element$iv2;
                QRCodeSquare cell = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                if (cell.getRendered()) continue;
                renderer.invoke((Object)(cell.absoluteX(cellSize) + margin), (Object)(cell.absoluteY(cellSize) + margin), (Object)cell, (Object)qrCodeGraphics);
                cell.setRendered(true);
            }
        }
        return qrCodeGraphics;
    }

    public static /* synthetic */ QRCodeGraphics renderShaded$default(QRCodeProcessor qRCodeProcessor, int n, int n2, QRCodeSquare[][] qRCodeSquareArray, QRCodeGraphics qRCodeGraphics, Function4 function4, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 25;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            qRCodeSquareArray = QRCodeProcessor.encode$default(qRCodeProcessor, 0, null, 3, null);
        }
        if ((n3 & 8) != 0) {
            qRCodeGraphics = qRCodeProcessor.graphicsFactory.newGraphicsSquare(qRCodeProcessor.computeImageSize(n, n2, qRCodeSquareArray));
        }
        return qRCodeProcessor.renderShaded(n, n2, qRCodeSquareArray, qRCodeGraphics, (Function4<? super Integer, ? super Integer, ? super QRCodeSquare, ? super QRCodeGraphics, Unit>)function4);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeSquare[][] encode(int type, @NotNull MaskPattern maskPattern) {
        QRCodeSquare[][] qRCodeSquareArray;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)((Object)maskPattern), (String)"maskPattern");
        int moduleCount = type * 4 + 17;
        QRCodeSquare[][] qRCodeSquareArray2 = new QRCodeSquare[moduleCount][];
        for (int i = 0; i < moduleCount; ++i) {
            int n3 = i;
            n2 = 0;
            QRCodeSquare[] qRCodeSquareArray3 = new QRCodeSquare[moduleCount];
            n = n3;
            qRCodeSquareArray = qRCodeSquareArray2;
            while (n2 < moduleCount) {
                int n4 = n2++;
                qRCodeSquareArray3[n4] = null;
            }
            qRCodeSquareArray[n] = qRCodeSquareArray3;
        }
        QRCodeSquare[][] modules = qRCodeSquareArray2;
        QRCodeSetup.setupTopLeftPositionProbePattern$default(QRCodeSetup.INSTANCE, modules, 0, 2, null);
        QRCodeSetup.setupTopRightPositionProbePattern$default(QRCodeSetup.INSTANCE, modules, 0, 2, null);
        QRCodeSetup.setupBottomLeftPositionProbePattern$default(QRCodeSetup.INSTANCE, modules, 0, 2, null);
        QRCodeSetup.INSTANCE.setupPositionAdjustPattern(type, modules);
        QRCodeSetup.INSTANCE.setupTimingPattern(moduleCount, modules);
        QRCodeSetup.INSTANCE.setupTypeInfo(this.errorCorrectionLevel, maskPattern, moduleCount, modules);
        if (type >= 7) {
            QRCodeSetup.INSTANCE.setupTypeNumber(type, moduleCount, modules);
        }
        int[] data = this.createData(type);
        QRCodeSetup.INSTANCE.applyMaskPattern(data, maskPattern, moduleCount, modules);
        QRCodeSquare[][] qRCodeSquareArray4 = new QRCodeSquare[moduleCount][];
        for (int i = 0; i < moduleCount; ++i) {
            n2 = i;
            QRCodeSquare[] qRCodeSquareArray5 = new QRCodeSquare[moduleCount];
            n = n2;
            qRCodeSquareArray = qRCodeSquareArray4;
            for (int j = 0; j < moduleCount; ++j) {
                int n5 = j;
                QRCodeSquare qRCodeSquare = modules[n2][n5];
                if (qRCodeSquare == null) {
                    qRCodeSquare = new QRCodeSquare(false, n2, n5, moduleCount, null, 0, 0, null, 240, null);
                }
                qRCodeSquareArray5[n5] = qRCodeSquare;
            }
            qRCodeSquareArray[n] = qRCodeSquareArray5;
        }
        return qRCodeSquareArray4;
    }

    public static /* synthetic */ QRCodeSquare[][] encode$default(QRCodeProcessor qRCodeProcessor, int n, MaskPattern maskPattern, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = qrcode.raw.QRCodeProcessor$Companion.typeForDataAndECL$default(Companion, qRCodeProcessor.data, qRCodeProcessor.errorCorrectionLevel, null, 4, null);
        }
        if ((n2 & 2) != 0) {
            maskPattern = MaskPattern.PATTERN000;
        }
        return qRCodeProcessor.encode(n, maskPattern);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] createData(int type) {
        RSBlock[] rsBlocks = RSBlock.Companion.getRSBlocks(type, this.errorCorrectionLevel);
        BitBuffer buffer = new BitBuffer();
        buffer.put(this.qrCodeData.getDataType().getValue(), 4);
        buffer.put(this.qrCodeData.length(), this.qrCodeData.getLengthInBits(type));
        this.qrCodeData.write(buffer);
        RSBlock[] rSBlockArray = rsBlocks;
        int n = 0;
        int n2 = rSBlockArray.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            RSBlock rSBlock;
            RSBlock rSBlock2 = rSBlock = rSBlockArray[i];
            int n3 = n;
            boolean bl = false;
            int n4 = it.getDataCount();
            n = n3 + n4;
        }
        int totalDataCount = n * 8;
        if (buffer.getLengthInBits() > totalDataCount) {
            throw new IllegalArgumentException("Code length overflow (" + buffer.getLengthInBits() + " > " + totalDataCount + ')');
        }
        if (buffer.getLengthInBits() + 4 <= totalDataCount) {
            buffer.put(0, 4);
        }
        while (buffer.getLengthInBits() % 8 != 0) {
            buffer.put(false);
        }
        while (buffer.getLengthInBits() < totalDataCount) {
            buffer.put(236, 8);
            if (buffer.getLengthInBits() >= totalDataCount) break;
            buffer.put(17, 8);
        }
        return this.createBytes(buffer, rsBlocks);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] createBytes(BitBuffer buffer, RSBlock[] rsBlocks) {
        int r;
        int i;
        int n;
        int offset = 0;
        int maxDcCount = 0;
        int maxEcCount = 0;
        int totalCodeCount = 0;
        int n2 = 0;
        int n3 = rsBlocks.length;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            nArrayArray[n4] = new int[0];
        }
        int[][] dcData = nArrayArray;
        n3 = 0;
        int n5 = rsBlocks.length;
        int[][] nArrayArray2 = new int[n5][];
        while (n3 < n5) {
            n = n3++;
            nArrayArray2[n] = new int[0];
        }
        int[][] ecData = nArrayArray2;
        RSBlock[] $this$forEachIndexed$iv = rsBlocks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (RSBlock item$iv : $this$forEachIndexed$iv) {
            void it;
            int n6 = index$iv++;
            RSBlock rSBlock = item$iv;
            int i2 = n6;
            boolean bl = false;
            int dcCount = it.getDataCount();
            int ecCount = it.getTotalCount() - dcCount;
            totalCodeCount += it.getTotalCount();
            maxDcCount = RangesKt.coerceAtLeast((int)maxDcCount, (int)dcCount);
            maxEcCount = RangesKt.coerceAtLeast((int)maxEcCount, (int)ecCount);
            int n7 = 0;
            int[] nArray = new int[dcCount];
            int n8 = i2;
            int[][] nArrayArray3 = dcData;
            while (n7 < dcCount) {
                int n9 = n7++;
                nArray[n9] = 0xFF & buffer.getBuffer()[n9 + offset];
            }
            nArrayArray3[n8] = nArray;
            offset += dcCount;
            Polynomial rsPoly = QRUtil.INSTANCE.getErrorCorrectPolynomial(ecCount);
            Polynomial rawPoly = new Polynomial(dcData[i2], rsPoly.len() - 1);
            Polynomial modPoly = rawPoly.mod(rsPoly);
            int ecDataSize = rsPoly.len() - 1;
            int[] nArray2 = new int[ecDataSize];
            n8 = i2;
            nArrayArray3 = ecData;
            for (int j = 0; j < ecDataSize; ++j) {
                int n10 = j;
                int modIndex = n10 + modPoly.len() - ecDataSize;
                nArray2[n10] = modIndex >= 0 ? modPoly.get(modIndex) : 0;
            }
            nArrayArray3[n8] = nArray2;
        }
        int index = 0;
        int[] data = new int[totalCodeCount];
        n = maxDcCount;
        for (i = 0; i < n; ++i) {
            int n11 = rsBlocks.length;
            for (r = 0; r < n11; ++r) {
                if (i >= dcData[r].length) continue;
                data[index++] = dcData[r][i];
            }
        }
        n = maxEcCount;
        for (i = 0; i < n; ++i) {
            int n12 = rsBlocks.length;
            for (r = 0; r < n12; ++r) {
                if (i >= ecData[r].length) continue;
                data[index++] = ecData[r][i];
            }
        }
        return data;
    }

    @NotNull
    public String toString() {
        return "QRCode(data=" + this.data + ", errorCorrectionLevel=" + (Object)((Object)this.errorCorrectionLevel) + ", dataType=" + (Object)((Object)this.dataType) + ", qrCodeData=" + Reflection.getOrCreateKotlinClass(this.qrCodeData.getClass()).getSimpleName() + ')';
    }

    @JvmOverloads
    public QRCodeProcessor(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel, @NotNull QRCodeDataType dataType) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        this(data, errorCorrectionLevel, dataType, null, 8, null);
    }

    @JvmOverloads
    public QRCodeProcessor(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        this(data, errorCorrectionLevel, null, null, 12, null);
    }

    @JvmOverloads
    public QRCodeProcessor(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data, null, null, null, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(int cellSize, int margin, @NotNull QRCodeSquare[][] rawData, @NotNull QRCodeGraphics qrCodeGraphics, int brightColor, int darkColor) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        return QRCodeProcessor.render$default(this, cellSize, margin, rawData, qrCodeGraphics, brightColor, darkColor, 0, 64, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(int cellSize, int margin, @NotNull QRCodeSquare[][] rawData, @NotNull QRCodeGraphics qrCodeGraphics, int brightColor) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        return QRCodeProcessor.render$default(this, cellSize, margin, rawData, qrCodeGraphics, brightColor, 0, 0, 96, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(int cellSize, int margin, @NotNull QRCodeSquare[][] rawData, @NotNull QRCodeGraphics qrCodeGraphics) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        return QRCodeProcessor.render$default(this, cellSize, margin, rawData, qrCodeGraphics, 0, 0, 0, 112, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(int cellSize, int margin, @NotNull QRCodeSquare[][] rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        return QRCodeProcessor.render$default(this, cellSize, margin, rawData, null, 0, 0, 0, 120, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(int cellSize, int margin) {
        return QRCodeProcessor.render$default(this, cellSize, margin, null, null, 0, 0, 0, 124, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render(int cellSize) {
        return QRCodeProcessor.render$default(this, cellSize, 0, null, null, 0, 0, 0, 126, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics render() {
        return QRCodeProcessor.render$default(this, 0, 0, null, null, 0, 0, 0, 127, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics renderShaded(int cellSize, int margin, @NotNull QRCodeSquare[][] rawData, @NotNull Function4<? super Integer, ? super Integer, ? super QRCodeSquare, ? super QRCodeGraphics, Unit> renderer) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        return QRCodeProcessor.renderShaded$default(this, cellSize, margin, rawData, null, renderer, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics renderShaded(int cellSize, int margin, @NotNull Function4<? super Integer, ? super Integer, ? super QRCodeSquare, ? super QRCodeGraphics, Unit> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        return QRCodeProcessor.renderShaded$default(this, cellSize, margin, null, null, renderer, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics renderShaded(int cellSize, @NotNull Function4<? super Integer, ? super Integer, ? super QRCodeSquare, ? super QRCodeGraphics, Unit> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        return QRCodeProcessor.renderShaded$default(this, cellSize, 0, null, null, renderer, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeGraphics renderShaded(@NotNull Function4<? super Integer, ? super Integer, ? super QRCodeSquare, ? super QRCodeGraphics, Unit> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        return QRCodeProcessor.renderShaded$default(this, 0, 0, null, null, renderer, 15, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeSquare[][] encode(int type) {
        return QRCodeProcessor.encode$default(this, type, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeSquare[][] encode() {
        return QRCodeProcessor.encode$default(this, 0, null, 3, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final int typeForDataAndECL(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel, @NotNull QRCodeDataType dataType) {
        return Companion.typeForDataAndECL(data, errorCorrectionLevel, dataType);
    }

    @JvmStatic
    @JvmOverloads
    public static final int typeForDataAndECL(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
        return Companion.typeForDataAndECL(data, errorCorrectionLevel);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lqrcode/raw/QRCodeProcessor$Companion;", "", "()V", "DEFAULT_CELL_SIZE", "", "DEFAULT_MARGIN", "PAD0", "PAD1", "typeForDataAndECL", "data", "", "errorCorrectionLevel", "Lqrcode/raw/ErrorCorrectionLevel;", "dataType", "Lqrcode/raw/QRCodeDataType;", "qrcode-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final int typeForDataAndECL(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel, @NotNull QRCodeDataType dataType) {
            QRData qRData;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
            Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
            switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                case 1: {
                    qRData = new QRNumber(data);
                    break;
                }
                case 2: {
                    qRData = new QRAlphaNum(data);
                    break;
                }
                case 3: {
                    qRData = new QR8BitByte(data);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            QRData qrCodeData = qRData;
            int dataLength = qrCodeData.length();
            int n = errorCorrectionLevel.getMaxTypeNum();
            for (int typeNum = 1; typeNum < n; ++typeNum) {
                if (dataLength > QRUtil.INSTANCE.getMaxLength(typeNum, dataType, errorCorrectionLevel)) continue;
                return typeNum;
            }
            return 40;
        }

        public static /* synthetic */ int typeForDataAndECL$default(Companion companion, String string, ErrorCorrectionLevel errorCorrectionLevel, QRCodeDataType qRCodeDataType, int n, Object object) {
            if ((n & 4) != 0) {
                qRCodeDataType = QRUtil.INSTANCE.getDataType(string);
            }
            return companion.typeForDataAndECL(string, errorCorrectionLevel, qRCodeDataType);
        }

        @JvmStatic
        @JvmOverloads
        public final int typeForDataAndECL(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
            return qrcode.raw.QRCodeProcessor$Companion.typeForDataAndECL$default(this, data, errorCorrectionLevel, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[QRCodeDataType.values().length];
                try {
                    nArray[QRCodeDataType.NUMBERS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QRCodeDataType.UPPER_ALPHA_NUM.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QRCodeDataType.DEFAULT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QRCodeDataType.values().length];
            try {
                nArray[QRCodeDataType.NUMBERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeDataType.UPPER_ALPHA_NUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeDataType.DEFAULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

