/*
 * Decompiled with CFR 0.152.
 */
package qrcode.render;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0012\u0010\u0017\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u0007H\u0014J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eJ5\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0#H\u0014\u00a2\u0006\u0002\u0010$J8\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010(\u001a\u00020\"H\u0016J\"\u0010)\u001a\u00020\u001c2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0016J\"\u0010)\u001a\u00020\u001c2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0016J8\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010(\u001a\u00020\"H\u0016J8\u00101\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010(\u001a\u00020\"H\u0016J@\u00102\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010(\u001a\u00020\"H\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0003H\u0016J0\u00105\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J0\u00106\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J8\u00107\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J\b\u00108\u001a\u00020+H\u0016J\u0010\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u0013H\u0016J\b\u0010:\u001a\u00020\u0001H\u0016J\u0006\u0010;\u001a\u00020\u001cJ\u001a\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>2\b\b\u0002\u00109\u001a\u00020\u0013H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006?"}, d2={"Lqrcode/render/QRCodeGraphics;", "", "width", "", "height", "(II)V", "changed", "", "colorCache", "Ljava/util/HashMap;", "Ljava/awt/Color;", "Lkotlin/collections/HashMap;", "getHeight", "()I", "image", "Ljava/awt/image/BufferedImage;", "getWidth", "availableFormats", "", "", "()[Ljava/lang/String;", "createGraphics", "Ljava/awt/Graphics2D;", "createImage", "force", "dimensions", "()[Ljava/lang/Integer;", "directDraw", "", "action", "Ljava/util/function/Consumer;", "draw", "color", "strokeThickness", "", "Lkotlin/Function1;", "(ILjava/lang/Double;Lkotlin/jvm/functions/Function1;)V", "drawEllipse", "x", "y", "thickness", "drawImage", "rawData", "", "drawLine", "x1", "y1", "x2", "y2", "drawRect", "drawRoundRect", "borderRadius", "fill", "fillEllipse", "fillRect", "fillRoundRect", "getBytes", "format", "nativeImage", "reset", "writeImage", "destination", "Ljava/io/OutputStream;", "qrcode-kotlin"})
public class QRCodeGraphics {
    private final int width;
    private final int height;
    private BufferedImage image;
    @NotNull
    private final HashMap<Integer, Color> colorCache;
    private boolean changed;

    public QRCodeGraphics(int width, int height) {
        this.width = width;
        this.height = height;
        this.colorCache = new HashMap();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    protected BufferedImage createImage(boolean force) {
        BufferedImage bufferedImage;
        if (force || this.image == null) {
            this.image = new BufferedImage(this.width, this.height, 2);
        }
        if ((bufferedImage = this.image) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"image");
            bufferedImage = null;
        }
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage createImage$default(QRCodeGraphics qRCodeGraphics, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createImage");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return qRCodeGraphics.createImage(bl);
    }

    @NotNull
    protected Graphics2D createGraphics() {
        Graphics2D graphics2D = QRCodeGraphics.createImage$default(this, false, 1, null).createGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
        return graphics2D;
    }

    protected void draw(int color, @Nullable Double strokeThickness, @NotNull Function1<? super Graphics2D, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.changed = true;
        Graphics2D graphics = this.createGraphics();
        Color color2 = this.colorCache.computeIfAbsent(color, arg_0 -> QRCodeGraphics.draw$lambda$0((Function1)new Function1<Integer, Color>(color){
            final /* synthetic */ int $color;
            {
                this.$color = $color;
                super(1);
            }

            @NotNull
            public final Color invoke(@NotNull Integer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new Color(this.$color, true);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"computeIfAbsent(...)");
        Color jdkColor2 = color2;
        if (strokeThickness != null && strokeThickness > 0.0) {
            graphics.setStroke(new BasicStroke((float)strokeThickness.doubleValue(), 1, 1));
        }
        graphics.setColor(jdkColor2);
        graphics.setBackground(jdkColor2);
        graphics.setPaint(jdkColor2);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        action.invoke((Object)graphics);
        graphics.dispose();
    }

    public static /* synthetic */ void draw$default(QRCodeGraphics qRCodeGraphics, int n, Double d, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: draw");
        }
        if ((n2 & 2) != 0) {
            d = null;
        }
        qRCodeGraphics.draw(n, d, (Function1<? super Graphics2D, Unit>)function1);
    }

    public boolean changed() {
        return this.changed;
    }

    public final void reset() {
        if (this.changed) {
            this.changed = false;
            this.createImage(true);
        }
    }

    @NotNull
    public Integer[] dimensions() {
        Integer[] integerArray = new Integer[]{this.width, this.height};
        return integerArray;
    }

    @NotNull
    public byte[] getBytes() {
        return this.getBytes("PNG");
    }

    @NotNull
    public byte[] getBytes(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        ByteArrayOutputStream it = new ByteArrayOutputStream();
        boolean bl = false;
        this.writeImage(it, format);
        byte[] byArray = it.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"let(...)");
        return byArray;
    }

    @JvmOverloads
    public void writeImage(@NotNull OutputStream destination, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        boolean wasImageWritten = ImageIO.write((RenderedImage)QRCodeGraphics.createImage$default(this, false, 1, null), format, destination);
        if (!wasImageWritten) {
            throw new UnsupportedOperationException("Unsupported format: " + format);
        }
    }

    public static /* synthetic */ void writeImage$default(QRCodeGraphics qRCodeGraphics, OutputStream outputStream, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeImage");
        }
        if ((n & 2) != 0) {
            string = "PNG";
        }
        qRCodeGraphics.writeImage(outputStream, string);
    }

    @NotNull
    public String[] availableFormats() {
        String[] stringArray = ImageIO.getWriterFileSuffixes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getWriterFileSuffixes(...)");
        return stringArray;
    }

    @NotNull
    public Object nativeImage() {
        return QRCodeGraphics.createImage$default(this, false, 1, null);
    }

    public void drawLine(int x1, int y1, int x2, int y2, int color, double thickness) {
        this.draw(color, thickness, (Function1<? super Graphics2D, Unit>)((Function1)new Function1<Graphics2D, Unit>(x1, y1, x2, y2){
            final /* synthetic */ int $x1;
            final /* synthetic */ int $y1;
            final /* synthetic */ int $x2;
            final /* synthetic */ int $y2;
            {
                this.$x1 = $x1;
                this.$y1 = $y1;
                this.$x2 = $x2;
                this.$y2 = $y2;
                super(1);
            }

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.drawLine(this.$x1, this.$y1, this.$x2, this.$y2);
            }
        }));
    }

    public void drawRect(int x, int y, int width, int height, int color, double thickness) {
        this.draw(color, thickness, (Function1<? super Graphics2D, Unit>)((Function1)new Function1<Graphics2D, Unit>(thickness, x, y, width, height){
            final /* synthetic */ double $thickness;
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            {
                this.$thickness = $thickness;
                this.$x = $x;
                this.$y = $y;
                this.$width = $width;
                this.$height = $height;
                super(1);
            }

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int halfThickness = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)(this.$thickness / 2.0)), (int)0);
                it.drawRect(this.$x + halfThickness, this.$y + halfThickness, this.$width - halfThickness * 2, this.$height - halfThickness * 2);
            }
        }));
    }

    public void fillRect(int x, int y, int width, int height, int color) {
        QRCodeGraphics.draw$default(this, color, null, (Function1)new Function1<Graphics2D, Unit>(x, y, width, height){
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            {
                this.$x = $x;
                this.$y = $y;
                this.$width = $width;
                this.$height = $height;
                super(1);
            }

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.fillRect(this.$x, this.$y, this.$width, this.$height);
            }
        }, 2, null);
    }

    public void fill(int color) {
        this.fillRect(0, 0, this.width, this.height, color);
    }

    public void drawRoundRect(int x, int y, int width, int height, int borderRadius, int color, double thickness) {
        this.draw(color, thickness, (Function1<? super Graphics2D, Unit>)((Function1)new Function1<Graphics2D, Unit>(thickness, x, y, width, height, borderRadius){
            final /* synthetic */ double $thickness;
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ int $borderRadius;
            {
                this.$thickness = $thickness;
                this.$x = $x;
                this.$y = $y;
                this.$width = $width;
                this.$height = $height;
                this.$borderRadius = $borderRadius;
                super(1);
            }

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int halfThickness = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)(this.$thickness / 2.0)), (int)0);
                it.drawRoundRect(this.$x + halfThickness, this.$y + halfThickness, this.$width - halfThickness * 2, this.$height - halfThickness * 2, this.$borderRadius, this.$borderRadius);
            }
        }));
    }

    public void fillRoundRect(int x, int y, int width, int height, int borderRadius, int color) {
        QRCodeGraphics.draw$default(this, color, null, (Function1)new Function1<Graphics2D, Unit>(x, y, width, height, borderRadius){
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ int $borderRadius;
            {
                this.$x = $x;
                this.$y = $y;
                this.$width = $width;
                this.$height = $height;
                this.$borderRadius = $borderRadius;
                super(1);
            }

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.fillRoundRect(this.$x, this.$y, this.$width, this.$height, this.$borderRadius, this.$borderRadius);
            }
        }, 2, null);
    }

    public void drawEllipse(int x, int y, int width, int height, int color, double thickness) {
        this.draw(color, thickness, (Function1<? super Graphics2D, Unit>)((Function1)new Function1<Graphics2D, Unit>(thickness, x, y, width, height){
            final /* synthetic */ double $thickness;
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            {
                this.$thickness = $thickness;
                this.$x = $x;
                this.$y = $y;
                this.$width = $width;
                this.$height = $height;
                super(1);
            }

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int halfThickness = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)(this.$thickness / 2.0)), (int)0);
                it.drawOval(this.$x + halfThickness, this.$y + halfThickness, this.$width - 1 - halfThickness * 2, this.$height - 1 - halfThickness * 2);
            }
        }));
    }

    public void fillEllipse(int x, int y, int width, int height, int color) {
        QRCodeGraphics.draw$default(this, color, null, (Function1)new Function1<Graphics2D, Unit>(x, y, width, height){
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            {
                this.$x = $x;
                this.$y = $y;
                this.$width = $width;
                this.$height = $height;
                super(1);
            }

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.fillOval(this.$x, this.$y, this.$width, this.$height);
            }
        }, 2, null);
    }

    public void drawImage(@Nullable byte[] rawData, int x, int y) {
        if (rawData != null && !(rawData.length == 0)) {
            QRCodeGraphics.draw$default(this, 0, null, (Function1)new Function1<Graphics2D, Unit>(rawData, this, x, y){
                final /* synthetic */ byte[] $rawData;
                final /* synthetic */ QRCodeGraphics this$0;
                final /* synthetic */ int $x;
                final /* synthetic */ int $y;
                {
                    this.$rawData = $rawData;
                    this.this$0 = $receiver;
                    this.$x = $x;
                    this.$y = $y;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull Graphics2D it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Closeable closeable = new ByteArrayInputStream(this.$rawData);
                    QRCodeGraphics qRCodeGraphics = this.this$0;
                    int n = this.$x;
                    int n2 = this.$y;
                    Throwable throwable = null;
                    try {
                        ByteArrayInputStream inStream = (ByteArrayInputStream)closeable;
                        boolean bl = false;
                        qRCodeGraphics.drawImage(ImageIO.read(inStream), n, n2);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }, 2, null);
        }
    }

    public void drawImage(@Nullable BufferedImage image, int x, int y) {
        if (image != null) {
            QRCodeGraphics.draw$default(this, 0, null, (Function1)new Function1<Graphics2D, Unit>(image, x, y){
                final /* synthetic */ BufferedImage $image;
                final /* synthetic */ int $x;
                final /* synthetic */ int $y;
                {
                    this.$image = $image;
                    this.$x = $x;
                    this.$y = $y;
                    super(1);
                }

                public final void invoke(@NotNull Graphics2D it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.drawImage((Image)this.$image, this.$x, this.$y, null);
                }
            }, 2, null);
        }
    }

    public final void directDraw(@NotNull Consumer<Graphics2D> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.draw(0, null, (Function1<? super Graphics2D, Unit>)((Function1)new Function1<Graphics2D, Unit>(action){
            final /* synthetic */ Consumer<Graphics2D> $action;
            {
                this.$action = $action;
                super(1);
            }

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$action.accept(it);
            }
        }));
    }

    @JvmOverloads
    public final void writeImage(@NotNull OutputStream destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        QRCodeGraphics.writeImage$default(this, destination, null, 2, null);
    }

    private static final Color draw$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Color)$tmp0.invoke(p0);
    }
}

