/*
 * Decompiled with CFR 0.152.
 */
package io.github.gageallencarpenter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Powershell {
    private final ExecutorService executor;

    public Powershell() {
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    }

    public Powershell(int threads) {
        this.executor = Executors.newFixedThreadPool(threads);
    }

    public List<String> execute(String script) {
        return this.executeScript(script);
    }

    public Future<List<String>> executeAsync(String script) {
        return this.executor.submit(() -> this.executeScript(script));
    }

    private List<String> executeScript(String script) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder("powershell.exe", "-Command", script);
            builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
            Process process = builder.start();
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = input.readLine()) != null) {
                output.add(line);
            }
            return output;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return output;
        }
    }
}

