/*
 * Decompiled with CFR 0.152.
 */
package io.github.galbiston.expiring_map;

import io.github.galbiston.expiring_map.ExpiringMapCleaner;
import java.lang.invoke.MethodHandles;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String label;
    private boolean running;
    private boolean expiring;
    private long maxSize;
    private long expiryInterval;
    private long cleanerInterval;
    private long fullMapWarningInterval;
    private long fullMapWarning;
    private ExpiringMapCleaner mapCleaner;
    private Timer cleanerTimer;

    public ExpiringMap(String label) {
        this(label, -1, 0L, 1000L, 30000L);
    }

    public ExpiringMap(String label, int maxSize) {
        this(label, maxSize, 0L, 1000L, 30000L);
    }

    public ExpiringMap(String label, int maxSize, long expiryInterval) {
        this(label, maxSize, expiryInterval, 1000L, 30000L);
    }

    public ExpiringMap(String label, int maxSize, long expiryInterval, long cleanerInterval) {
        this(label, maxSize, expiryInterval, cleanerInterval, 30000L);
    }

    public ExpiringMap(String label, int maxSize, long expiryInterval, long cleanerInterval, long fullMapWarningInterval) {
        super(maxSize > -1 ? maxSize : 50000);
        this.label = label;
        this.setMaxSize(maxSize);
        this.running = false;
        this.expiring = false;
        this.cleanerTimer = null;
        this.mapCleaner = null;
        this.setCleanerInterval(cleanerInterval);
        this.setExpiryInterval(expiryInterval);
        this.fullMapWarningInterval = fullMapWarningInterval;
        this.fullMapWarning = System.currentTimeMillis();
    }

    @Override
    public V put(K key, V value) {
        if (super.mappingCount() < this.maxSize) {
            this.mapCleaner.put(key);
            return super.put(key, value);
        }
        long currentSystemTime = System.currentTimeMillis();
        long difference = currentSystemTime - this.fullMapWarning;
        if (difference > this.fullMapWarningInterval) {
            this.fullMapWarning = currentSystemTime;
            LOGGER.warn("{} Map Full: {} - Warning suppressed for {}ms", new Object[]{this.label, this.maxSize, this.fullMapWarningInterval});
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean isContained = super.containsKey(key);
        if (isContained) {
            this.mapCleaner.refresh(key);
        }
        return isContained;
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (value != null) {
            this.mapCleaner.refresh(key);
        }
        return value;
    }

    @Override
    public void clear() {
        super.clear();
        this.mapCleaner.clear();
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(long maxSize) {
        this.maxSize = maxSize > -1L ? maxSize : Long.MAX_VALUE;
    }

    public long getCleanerInterval() {
        return this.cleanerInterval;
    }

    public final void setCleanerInterval(long cleanerInterval) {
        boolean isChanged = this.applyCleanerInterval(cleanerInterval);
        if (this.running && isChanged) {
            this.startExpiry();
        }
    }

    private boolean applyCleanerInterval(long cleanerInterval) {
        long originalCleanerInterval = this.cleanerInterval;
        if (100L < cleanerInterval) {
            this.cleanerInterval = cleanerInterval;
        } else {
            LOGGER.warn("Cleaner Interval: {} less than minimum: {}. Setting to minimum.", (Object)cleanerInterval, (Object)100L);
            this.cleanerInterval = 100L;
        }
        return originalCleanerInterval != this.cleanerInterval;
    }

    public long getExpiryInterval() {
        return this.expiryInterval;
    }

    public final void setExpiryInterval(long expiryInterval) {
        this.expiring = expiryInterval > 0L;
        long minimum_interval = this.cleanerInterval + 1L;
        if (expiryInterval < minimum_interval) {
            if (this.expiring) {
                LOGGER.warn("Expiry Interval: {} cannot be less than Cleaner Interval: {}. Setting to Minimum Interval: {}", new Object[]{expiryInterval, this.cleanerInterval, minimum_interval});
            }
            this.expiryInterval = minimum_interval;
        } else {
            this.expiryInterval = expiryInterval;
        }
        if (this.mapCleaner == null) {
            this.mapCleaner = new ExpiringMapCleaner(this, expiryInterval);
        } else {
            this.mapCleaner.setExpiryInterval(this.expiryInterval);
        }
    }

    public long getFullMapWarningInterval() {
        return this.fullMapWarningInterval;
    }

    public void setFullMapWarningInterval(long fullMapWarningInterval) {
        this.fullMapWarningInterval = fullMapWarningInterval;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void startExpiry() {
        this.startExpiry(this.cleanerInterval);
    }

    public void startExpiry(long cleanerInterval) {
        this.stopExpiry();
        if (this.expiring) {
            this.applyCleanerInterval(cleanerInterval);
            this.cleanerTimer = new Timer(this.label, true);
            this.mapCleaner = new ExpiringMapCleaner(this.mapCleaner);
            this.cleanerTimer.scheduleAtFixedRate((TimerTask)this.mapCleaner, this.cleanerInterval, this.cleanerInterval);
        }
        this.running = true;
    }

    public void stopExpiry() {
        if (this.cleanerTimer != null) {
            this.cleanerTimer.cancel();
            this.cleanerTimer = null;
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isExpiring() {
        return this.expiring;
    }

    @Override
    public String toString() {
        return "ExpiringMap{label=" + this.label + ", running=" + this.running + ", expiring=" + this.expiring + ", maxSize=" + this.maxSize + ", expiryInterval=" + this.expiryInterval + ", cleanerInterval=" + this.cleanerInterval + ", fullMapWarningInterval=" + this.fullMapWarningInterval + ", fullMapWarning=" + this.fullMapWarning + ", mapCleaner=" + this.mapCleaner + ", cleanerTimer=" + this.cleanerTimer + '}';
    }
}

