/*
 * Decompiled with CFR 0.152.
 */
package io.github.galbiston.expiring_map;

import io.github.galbiston.expiring_map.ExpiringMap;
import io.github.galbiston.expiring_map.KeyTimestampPair;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class ExpiringMapCleaner
extends TimerTask {
    private final SortedSet<KeyTimestampPair> tracking = Collections.synchronizedSortedSet(new TreeSet());
    private final ConcurrentHashMap<Object, Long> refresh = new ConcurrentHashMap();
    private final ExpiringMap map;
    private long expiryInterval;

    public ExpiringMapCleaner(ExpiringMap map, long expiryInterval) {
        this.map = map;
        this.expiryInterval = expiryInterval;
    }

    public ExpiringMapCleaner(ExpiringMapCleaner mapCleaner) {
        this.map = mapCleaner.map;
        this.expiryInterval = mapCleaner.expiryInterval;
        this.tracking.addAll(mapCleaner.tracking);
        this.refresh.putAll(mapCleaner.refresh);
    }

    @Override
    public void run() {
        long thresholdTimestamp = System.currentTimeMillis() - this.expiryInterval;
        boolean isEarlier = true;
        while (isEarlier) {
            if (this.tracking.isEmpty()) {
                return;
            }
            KeyTimestampPair current = this.tracking.first();
            isEarlier = current.isEarlier(thresholdTimestamp);
            if (!isEarlier) continue;
            Object key = current.getKey();
            this.tracking.remove(current);
            if (this.refresh.containsKey(key)) {
                Long timestamp = this.refresh.get(key);
                if (thresholdTimestamp < timestamp) {
                    this.tracking.add(new KeyTimestampPair(key, timestamp));
                }
                this.refresh.remove(key);
                continue;
            }
            this.map.remove(key);
        }
    }

    public synchronized void refresh(Object key) {
        this.refresh.put(key, System.currentTimeMillis());
    }

    public synchronized void put(Object key) {
        this.tracking.add(new KeyTimestampPair(key, System.currentTimeMillis()));
    }

    public synchronized void setExpiryInterval(long expiryInterval) {
        this.expiryInterval = expiryInterval;
    }

    public synchronized void clear() {
        this.tracking.clear();
    }
}

