/*
 * Decompiled with CFR 0.152.
 */
package io.github.galbiston.expiring_map;

import java.util.Objects;

public class KeyTimestampPair
implements Comparable<KeyTimestampPair> {
    private final Object key;
    private long timestamp;

    public KeyTimestampPair(Object key, long timestamp) {
        this.key = key;
        this.timestamp = timestamp;
    }

    public boolean hasKey(Object key) {
        return this.key.equals(key);
    }

    public Object getKey() {
        return this.key;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isEarlier(long timestamp) {
        return this.timestamp < timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(KeyTimestampPair o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.timestamp < o.timestamp) {
            return -1;
        }
        if (this.timestamp > o.timestamp) {
            return 1;
        }
        if (this.key.equals(o.key)) {
            return 0;
        }
        return -1;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.key);
        hash = 67 * hash + (int)(this.timestamp ^ this.timestamp >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyTimestampPair other = (KeyTimestampPair)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "KeyTimestampPair{key=" + this.key + ", timestamp=" + this.timestamp + '}';
    }
}

