/*
 * Decompiled with CFR 0.152.
 */
package com.langchainbeam;

import com.langchainbeam.LangchainModelHandler;
import com.langchainbeam.model.LangchainBeamOutput;
import com.langchainbeam.model.LangchainModelBuilder;
import com.langchainbeam.model.LangchainModelOptions;
import com.langchainbeam.model.ModelPrompt;
import dev.langchain4j.model.chat.ChatLanguageModel;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apache.beam.sdk.transforms.DoFn;

class LangchainBeamDoFn<T>
extends DoFn<String, LangchainBeamOutput> {
    private final LangchainModelHandler handler;
    private ChatLanguageModel model;
    private LangchainModelBuilder modelBuilder;
    private String modelOutput;
    private String modelOutputFormat;

    public LangchainBeamDoFn(LangchainModelHandler handler) {
        this.handler = handler;
    }

    @DoFn.Setup
    public void setup() throws Exception {
        LangchainModelOptions options = this.handler.getOptions();
        Class<? extends LangchainModelBuilder> modelBuilderClass = options.getModelBuilderClass();
        try {
            this.modelBuilder = modelBuilderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new Exception("Failed to set up Langchain model due to instantiation error: ", e);
        }
        this.modelOutputFormat = Objects.requireNonNullElse(this.handler.getOutputFormat(), "Plain text");
        this.modelBuilder.setOptions(options);
        this.model = this.modelBuilder.build();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context) {
        String input = (String)context.element();
        String finalPrompt = String.format(ModelPrompt.PROMPT, input, this.handler.getPrompt(), this.modelOutputFormat);
        this.modelOutput = this.model.generate(finalPrompt);
        LangchainBeamOutput lbModelOutput = LangchainBeamOutput.builder().inputElement(input).output(this.modelOutput).build();
        context.output((Object)lbModelOutput);
    }
}

