package com.langchainbeam.model;

import java.io.Serializable;
import java.util.Objects;

import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.SerializableCoder;

import lombok.Builder;

/**
 * A {@link Serializable} class represents the output of a LangChain-based Beam
 * processing task. This class encapsulates
 * the input element along with its associated output generated by the LangChain
 * model.
 */
@DefaultCoder(SerializableCoder.class)
public class LangchainBeamOutput implements Serializable {

    private final String inputElement;
    private final String output;

    @Builder
    public LangchainBeamOutput(String output, String inputElement) {
        this.output = output;
        this.inputElement = inputElement;
    }

    /**
     * gets the output generated by the model
     * 
     */
    public String getOutput() {
        return output;
    }

    /**
     * Gets the input element that was processed by the model.
     * 
     * @return
     */
    public String getInputElement() {
        return inputElement;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        LangchainBeamOutput that = (LangchainBeamOutput) o;
        return Objects.equals(inputElement, that.inputElement) &&
                Objects.equals(output, that.output);
    }

    @Override
    public int hashCode() {
        return Objects.hash(inputElement, output);
    }

}
