/*
 * Decompiled with CFR 0.152.
 */
package com.langchainbeam;

import com.langchainbeam.EmbeddingModelHandler;
import com.langchainbeam.model.BeamEmbedding;
import com.langchainbeam.model.EmbeddingModelBuilder;
import com.langchainbeam.model.EmbeddingOutput;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import java.lang.reflect.InvocationTargetException;
import org.apache.beam.sdk.transforms.DoFn;

class EmbeddingDoFn
extends DoFn<String, EmbeddingOutput> {
    private final EmbeddingModelHandler handler;
    private EmbeddingModelBuilder modelBuilder;
    private EmbeddingModel model;
    private Response<Embedding> response;

    public EmbeddingDoFn(EmbeddingModelHandler handler) {
        this.handler = handler;
    }

    @DoFn.Setup
    public void setupModel() throws Exception {
        Class<? extends EmbeddingModelBuilder> modelBuilderClass = this.handler.getOptions().getModelBuilderClass();
        try {
            this.modelBuilder = modelBuilderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new Exception("Failed to set up Embedding model due to instantiation error: ", e);
        }
        this.modelBuilder.setOptions(this.handler.getOptions());
        this.model = this.modelBuilder.build();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context) {
        String input = (String)context.element();
        this.response = this.model.embed(input);
        EmbeddingOutput embeddingOutput = EmbeddingOutput.builder().embedding(new BeamEmbedding(((Embedding)this.response.content()).vector())).inputElement(input).build();
        context.output((Object)embeddingOutput);
    }
}

