/*
 * Decompiled with CFR 0.152.
 */
package com.langchainbeam;

import com.langchainbeam.EmbeddingDoFn;
import com.langchainbeam.EmbeddingModelHandler;
import com.langchainbeam.model.EmbeddingOutput;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;

public class LangchainBeamEmbedding
extends PTransform<PCollection<String>, PCollection<EmbeddingOutput>> {
    private final EmbeddingModelHandler handler;

    private LangchainBeamEmbedding(EmbeddingModelHandler modelHandler) {
        this.handler = modelHandler;
    }

    public PCollection<EmbeddingOutput> expand(PCollection<String> input) {
        return (PCollection)input.apply("Embedding transform", (PTransform)ParDo.of((DoFn)new EmbeddingDoFn(this.handler)));
    }

    public static LangchainBeamEmbedding embed(EmbeddingModelHandler modelHandler) {
        if (modelHandler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        return new LangchainBeamEmbedding(modelHandler);
    }
}

