/*
 * Decompiled with CFR 0.152.
 */
package io.github.gasparbarancelli;

import io.github.gasparbarancelli.NativeQuery;
import io.github.gasparbarancelli.NativeQueryRegistryImpl;
import io.github.gasparbarancelli.PropertyUtil;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NativeQueryAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeQueryAutoConfiguration.class);
    public static final String SQL_DIRECTORY = "nativeQuery";

    @Bean
    public BeanFactoryPostProcessor beanFactoryPostProcessor() {
        return bf -> {
            LOGGER.debug("starting configuration");
            BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)bf;
            String packageScan = PropertyUtil.getValue("native-query.package-scan", "io.github.gasparbarancelli");
            LOGGER.debug("packageScan {}", (Object)packageScan);
            Reflections reflections = new Reflections(packageScan, new Scanner[0]);
            LOGGER.debug("looking for interfaces that implement NativeQuery");
            Set nativeQueryList = reflections.getSubTypesOf(NativeQuery.class);
            LOGGER.debug("{} found interfaces", (Object)nativeQueryList.size());
            NativeQueryRegistryImpl nativeQueryRegistry = new NativeQueryRegistryImpl(beanDefinitionRegistry);
            nativeQueryRegistry.registry(nativeQueryList);
        };
    }
}

