/*
 * Decompiled with CFR 0.152.
 */
package io.github.gasparbarancelli;

import io.github.gasparbarancelli.NativeQuery;
import io.github.gasparbarancelli.NativeQueryAccessField;
import io.github.gasparbarancelli.NativeQueryAccessMethod;
import io.github.gasparbarancelli.NativeQueryFieldInfo;
import io.github.gasparbarancelli.NativeQueryInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeQueryCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeQueryCache.class);
    private static final Map<NativeQueryInfoKey, NativeQueryInfo> CACHE_NATIVE_QUERY_INFO = new HashMap<NativeQueryInfoKey, NativeQueryInfo>();
    private static final Map<String, Map<String, NativeQueryFieldInfo>> CACHE_FIELD_INFO = new HashMap<String, Map<String, NativeQueryFieldInfo>>();
    private static final Map<String, List<NativeQueryAccessMethod>> CACHE_ACCESS_METHODS = new HashMap<String, List<NativeQueryAccessMethod>>();

    static NativeQueryInfo get(Class<? extends NativeQuery> classe, MethodInvocation invocation) {
        NativeQueryInfoKey nativeQueryInfoKey = new NativeQueryInfoKey(classe.getName(), invocation.getMethod().getName());
        LOGGER.debug("information cache key {}", (Object)nativeQueryInfoKey.toString());
        NativeQueryInfo info = CACHE_NATIVE_QUERY_INFO.get(nativeQueryInfoKey);
        if (info == null) {
            info = NativeQueryInfo.of(classe, invocation);
            LOGGER.debug("caching method {} information from interface {}", (Object)invocation.getMethod().getName(), (Object)classe.getName());
            CACHE_NATIVE_QUERY_INFO.put(nativeQueryInfoKey, info);
        } else {
            try {
                LOGGER.debug("getting from the cache the information of method {} of class {}", (Object)invocation.getMethod().getName(), (Object)classe.getName());
                info = (NativeQueryInfo)info.clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.debug("error in cloning the information that was cached in method {} of class {}", (Object)invocation.getMethod().getName(), (Object)classe.getName());
                throw new RuntimeException(e);
            }
        }
        NativeQueryInfo.setParameters(info, invocation);
        return info;
    }

    static List<NativeQueryAccessMethod> getAccessMethods(Class<?> classe) {
        String className = classe.getName();
        List<NativeQueryAccessMethod> methods = CACHE_ACCESS_METHODS.get(className);
        if (methods == null) {
            methods = new ArrayList<NativeQueryAccessMethod>();
            for (Method method : classe.getDeclaredMethods()) {
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                methods.add(new NativeQueryAccessMethod(method));
            }
            CACHE_ACCESS_METHODS.put(className, methods);
        }
        return methods;
    }

    static Map<String, NativeQueryFieldInfo> getFieldInfo(Class<?> classe) {
        String className = classe.getName();
        Map<String, NativeQueryFieldInfo> fieldInfoMap = CACHE_FIELD_INFO.get(className);
        if (fieldInfoMap == null) {
            fieldInfoMap = new HashMap<String, NativeQueryFieldInfo>();
            List<NativeQueryAccessField> accessFields = NativeQueryCache.getAccessFields(classe);
            for (NativeQueryAccessField accessField : accessFields) {
                fieldInfoMap.put(accessField.getName(), new NativeQueryFieldInfo(accessField.getParam(), accessField.getType()));
            }
            List<NativeQueryAccessMethod> accessMethods = NativeQueryCache.getAccessMethods(classe);
            for (NativeQueryAccessMethod accessMethod : accessMethods) {
                if (fieldInfoMap.get(accessMethod.getName()) != null) continue;
                fieldInfoMap.put(accessMethod.getName(), new NativeQueryFieldInfo(accessMethod.getParam(), accessMethod.getType()));
            }
            CACHE_FIELD_INFO.put(className, fieldInfoMap);
        }
        return fieldInfoMap;
    }

    private static List<NativeQueryAccessField> getAccessFields(Class<?> classe) {
        ArrayList<NativeQueryAccessField> fields = new ArrayList<NativeQueryAccessField>();
        for (Field field : classe.getDeclaredFields()) {
            fields.add(new NativeQueryAccessField(field));
        }
        return fields;
    }

    private static class NativeQueryInfoKey {
        String className;
        String methodName;

        public NativeQueryInfoKey(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NativeQueryInfoKey nativeQueryInfoKey = (NativeQueryInfoKey)o;
            return Objects.equals(this.className, nativeQueryInfoKey.className) && Objects.equals(this.methodName, nativeQueryInfoKey.methodName);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.methodName);
        }

        public String toString() {
            return "NativeQueryInfoKey{className='" + this.className + "', methodName='" + this.methodName + "'}";
        }
    }
}

