/*
 * Decompiled with CFR 0.152.
 */
package io.github.gasparbarancelli;

import io.github.gasparbarancelli.ApplicationContextProvider;
import io.github.gasparbarancelli.NativeQuery;
import io.github.gasparbarancelli.NativeQueryFileName;
import io.github.gasparbarancelli.NativeQueryFolder;
import io.github.gasparbarancelli.NativeQueryParam;
import io.github.gasparbarancelli.NativeQueryParameter;
import io.github.gasparbarancelli.NativeQueryReplaceSql;
import io.github.gasparbarancelli.NativeQueryReplaceSqlParams;
import io.github.gasparbarancelli.NativeQuerySql;
import io.github.gasparbarancelli.NativeQueryTenantNamedParameterJdbcTemplateInterceptor;
import io.github.gasparbarancelli.NativeQueryUseHibernateTypes;
import io.github.gasparbarancelli.NativeQueryUseJdbcTemplate;
import io.github.gasparbarancelli.ProcessorSql;
import io.github.gasparbarancelli.PropertyUtil;
import io.github.gasparbarancelli.engine.jtwig.JtwigTemplateEngineSQLProcessor;
import jakarta.persistence.Entity;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class NativeQueryInfo
implements Serializable,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeQueryInfo.class);
    private String file;
    private List<NativeQueryParameter> parameterList;
    private Pageable pageable;
    private Sort sort;
    private Class<?> aliasToBean;
    private Class<?> returnType;
    private boolean returnTypeIsIterable;
    private String sql;
    private String sqlInline;
    private boolean useSqlInline;
    private Boolean isEntity;
    private boolean useJdbcTemplate;
    private boolean useTenant;
    private boolean useHibernateTypes;
    private final Map<String, String> replaceSql = new HashMap<String, String>();
    private final List<Class<ProcessorSql>> processorSqlList = new ArrayList<Class<ProcessorSql>>();

    private NativeQueryInfo() {
    }

    public static NativeQueryInfo of(Class<? extends NativeQuery> classe, MethodInvocation invocation) {
        NativeQueryInfo info = new NativeQueryInfo();
        Method method = invocation.getMethod();
        LOGGER.debug("invoked method {}", (Object)method.getName());
        info.useSqlInline = method.isAnnotationPresent(NativeQuerySql.class);
        if (info.useSqlInline) {
            LOGGER.debug("sql obtained using the NativeQuerySql annotation");
            info.sqlInline = method.getAnnotation(NativeQuerySql.class).value();
        } else {
            NativeQueryInfo.setFile(classe, invocation, info);
        }
        info.useHibernateTypes = method.isAnnotationPresent(NativeQueryUseHibernateTypes.class) ? method.getAnnotation(NativeQueryUseHibernateTypes.class).useHibernateTypes() : Boolean.parseBoolean(PropertyUtil.getValue("native-query.use-hibernate-types", "true"));
        LOGGER.debug("use hibernate types {}", (Object)info.useHibernateTypes);
        info.useJdbcTemplate = method.isAnnotationPresent(NativeQueryUseJdbcTemplate.class);
        if (info.useJdbcTemplate) {
            LOGGER.debug("use JdbcTemplate");
            NativeQueryReplaceSqlParams[] jdbcTemplate = method.getAnnotation(NativeQueryUseJdbcTemplate.class);
            info.useTenant = jdbcTemplate.useTenant();
            LOGGER.debug("use JdbcTemplate with tenant {}", (Object)info.useTenant);
        }
        if (method.isAnnotationPresent(NativeQueryReplaceSql.class) && method.getAnnotation(NativeQueryReplaceSql.class).values().length > 0) {
            LOGGER.debug("makes use of sql change");
            for (NativeQueryReplaceSqlParams value : method.getAnnotation(NativeQueryReplaceSql.class).values()) {
                LOGGER.debug("replace key {} and value {}", (Object)value.key(), (Object)value.value());
                info.replaceSql.put(value.key(), value.value());
            }
            info.processorSqlList.addAll(Arrays.asList(method.getAnnotation(NativeQueryReplaceSql.class).processorParams()));
        }
        info.returnType = method.getReturnType();
        LOGGER.debug("return type {}", (Object)info.returnType.getName());
        info.returnTypeIsIterable = Iterable.class.isAssignableFrom(info.returnType);
        LOGGER.debug("return type is iterable {}", (Object)info.returnTypeIsIterable);
        if (info.returnTypeIsIterable || info.returnTypeIsOptional()) {
            TypeInformation componentType = ClassTypeInformation.fromReturnTypeOf((Method)method).getComponentType();
            info.aliasToBean = Objects.requireNonNull(componentType).getType();
        } else {
            info.aliasToBean = info.returnType;
        }
        LOGGER.debug("return object is {}", (Object)info.aliasToBean.getName());
        return info;
    }

    public static void setParameters(NativeQueryInfo info, MethodInvocation invocation) {
        info.sql = null;
        info.sort = null;
        info.parameterList = new ArrayList<NativeQueryParameter>();
        info.pageable = null;
        for (int i = 0; i < invocation.getArguments().length; ++i) {
            Object argument = invocation.getArguments()[i];
            Parameter parameter = invocation.getMethod().getParameters()[i];
            if (parameter.getType().isAssignableFrom(Pageable.class)) {
                info.pageable = (Pageable)argument;
                if (info.sort != null) continue;
                info.sort = info.pageable.getSort();
                continue;
            }
            if (parameter.getType().isAssignableFrom(Sort.class)) {
                info.sort = (Sort)argument;
                continue;
            }
            if (parameter.isAnnotationPresent(NativeQueryParam.class)) {
                NativeQueryParam param = parameter.getAnnotation(NativeQueryParam.class);
                if (param.addChildren()) {
                    info.parameterList.addAll(NativeQueryParameter.ofDeclaredMethods(param.value(), parameter.getType(), argument));
                    continue;
                }
                if (argument instanceof Map) {
                    info.parameterList.addAll(NativeQueryParameter.ofMap((Map)argument, param.value()));
                    continue;
                }
                info.parameterList.add(new NativeQueryParameter(param.value(), param.operator().getTransformParam().apply(argument)));
                continue;
            }
            if (argument instanceof Map) {
                info.parameterList.addAll(NativeQueryParameter.ofMap((Map)argument, parameter.getName()));
                continue;
            }
            info.parameterList.add(new NativeQueryParameter(parameter.getName(), argument));
        }
        for (NativeQueryParameter parameter : info.parameterList) {
            LOGGER.debug("Parameter {} containing the value {} added", (Object)parameter.getName(), parameter.getValue());
        }
    }

    private static void setFile(Class<? extends NativeQuery> classe, MethodInvocation invocation, NativeQueryInfo info) {
        Method method;
        info.file = PropertyUtil.getValue("native-query.sql.directory", "nativeQuery");
        if (!info.file.endsWith("/")) {
            info.file = info.file + "/";
        }
        if (classe.isAnnotationPresent(NativeQueryFolder.class)) {
            info.file = info.file + classe.getAnnotation(NativeQueryFolder.class).value() + File.separator;
        }
        info.file = (method = invocation.getMethod()).isAnnotationPresent(NativeQueryFileName.class) ? info.file + method.getAnnotation(NativeQueryFileName.class).value() + "." : info.file + method.getName() + ".";
        String fileSufix = PropertyUtil.getValue("native-query.file.sufix", "twig");
        info.file = new ClassPathResource(info.file + fileSufix).exists() ? info.file + fileSufix : (new ClassPathResource(info.file + "sql").exists() ? info.file + "sql" : info.file + "twig");
        LOGGER.debug("sql obtained through the {} file", (Object)info.file);
    }

    String getSql() {
        if (this.sql != null) {
            return this.sql;
        }
        this.sql = this.getSqlProcessed();
        for (Class<ProcessorSql> clazz : this.processorSqlList) {
            try {
                ProcessorSql processor = clazz.newInstance();
                processor.execute(this.sql, this.replaceSql);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        for (Map.Entry entry : this.replaceSql.entrySet()) {
            this.sql = this.sql.replaceAll("\\$\\{" + (String)entry.getKey() + "}", (String)entry.getValue());
        }
        if (this.sort != null) {
            StringBuilder orderBuilder = new StringBuilder();
            for (Sort.Order order : this.sort) {
                if (orderBuilder.length() == 0) {
                    orderBuilder.append(" ORDER BY ");
                } else {
                    orderBuilder.append(", ");
                }
                orderBuilder.append(order.getProperty()).append(" ").append(order.getDirection().name());
                Sort.NullHandling nulls = order.getNullHandling();
                if (nulls == Sort.NullHandling.NATIVE) continue;
                orderBuilder.append(" ").append(nulls.name().replace('_', ' '));
            }
            this.sql = this.sql + orderBuilder.toString();
        }
        if (this.useTenant) {
            NativeQueryTenantNamedParameterJdbcTemplateInterceptor tenantJdbcTemplate = (NativeQueryTenantNamedParameterJdbcTemplateInterceptor)ApplicationContextProvider.getApplicationContext().getBean(NativeQueryTenantNamedParameterJdbcTemplateInterceptor.class);
            this.sql = this.sql.replace(":SCHEMA", tenantJdbcTemplate.getTenant());
        }
        LOGGER.debug("SQL to be executed: {}", (Object)this.sql);
        return this.sql;
    }

    private String getSqlProcessed() {
        return new JtwigTemplateEngineSQLProcessor().setParameter(this.parameterList).inline(this.useSqlInline).setClasspathTemplate(this.file).setInlineTemplate(this.sqlInline).getSql();
    }

    String getSqlTotalRecord() {
        String sqlCount = "select count(*) as totalRecords from (" + this.getSql() + ") x";
        LOGGER.debug("SQL Count to be executed: {}", (Object)this.sql);
        return sqlCount;
    }

    public boolean isUseJdbcTemplate() {
        return this.useJdbcTemplate;
    }

    boolean isEntity() {
        if (this.isEntity == null) {
            this.isEntity = this.aliasToBean.isAnnotationPresent(Entity.class);
        }
        LOGGER.debug("is entity {}", (Object)this.isEntity);
        return this.isEntity;
    }

    boolean isJavaObject() {
        boolean isJavaObject = this.getPackageName(this.aliasToBean).startsWith("java");
        LOGGER.debug("is java Object {}", (Object)isJavaObject);
        return isJavaObject;
    }

    private String getPackageName(Class<?> c) {
        String cn;
        int dot;
        while (c.isArray()) {
            c = c.getComponentType();
        }
        String pn = c.isPrimitive() ? "java.lang" : ((dot = (cn = c.getName()).lastIndexOf(46)) != -1 ? cn.substring(0, dot).intern() : "");
        return pn;
    }

    boolean isPagination() {
        boolean isPagination = Page.class.isAssignableFrom(this.returnType);
        LOGGER.debug("is pagination {}", (Object)isPagination);
        return isPagination;
    }

    boolean isSingleResult() {
        boolean isSingleResult = !this.returnTypeIsIterable;
        LOGGER.debug("is single result {}", (Object)isSingleResult);
        return isSingleResult;
    }

    boolean hasPagination() {
        boolean hasPagiation = this.pageable != null;
        LOGGER.debug("has pagination {}", (Object)hasPagiation);
        return hasPagiation;
    }

    Pageable getPageable() {
        return this.pageable;
    }

    int getFirstResult() {
        int firstResult = this.pageable.getPageSize() * this.pageable.getPageNumber();
        LOGGER.debug("first result {}", (Object)firstResult);
        return firstResult;
    }

    int getMaxResult() {
        int maxResult = this.pageable.getPageSize();
        LOGGER.debug("max result {}", (Object)maxResult);
        return maxResult;
    }

    public String getFile() {
        return this.file;
    }

    List<NativeQueryParameter> getParameterList() {
        return this.parameterList;
    }

    Class<?> getAliasToBean() {
        LOGGER.debug("alias to bean {}", (Object)this.aliasToBean.getName());
        return this.aliasToBean;
    }

    Class<?> getReturnType() {
        LOGGER.debug("return type {}", (Object)this.returnType.getName());
        return this.returnType;
    }

    public boolean isReturnTypeIsIterable() {
        LOGGER.debug("is return type is iterable {}", (Object)this.returnTypeIsIterable);
        return this.returnTypeIsIterable;
    }

    public Boolean getIsEntity() {
        return this.isEntity;
    }

    public Map<String, String> getReplaceSql() {
        return this.replaceSql;
    }

    public List<Class<ProcessorSql>> getProcessorSqlList() {
        return this.processorSqlList;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean returnTypeIsOptional() {
        boolean typeIsOptional = this.returnType.getSimpleName().equals(Optional.class.getSimpleName());
        LOGGER.debug("Return type is optional {}", (Object)typeIsOptional);
        return typeIsOptional;
    }

    public boolean isUseHibernateTypes() {
        return this.useHibernateTypes;
    }
}

