/*
 * Decompiled with CFR 0.152.
 */
package io.github.gasparbarancelli;

import io.github.gasparbarancelli.ApplicationContextProvider;
import io.github.gasparbarancelli.HibernateTypesMapper;
import io.github.gasparbarancelli.NativeQueryInfo;
import io.github.gasparbarancelli.NativeQueryMethodInterceptor;
import io.github.gasparbarancelli.NativeQueryParameter;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.PageImpl;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class NativeQueryMethodInterceptorImpl
implements NativeQueryMethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeQueryMethodInterceptorImpl.class);

    @Override
    public Object executeQuery(NativeQueryInfo info) {
        if (!info.isUseJdbcTemplate()) {
            return this.executeWithEntityManager(info);
        }
        return this.executeWithJdbcTemplate(info);
    }

    private Object executeWithJdbcTemplate(NativeQueryInfo info) {
        LOGGER.debug("SQL will be executed with JdbcTemplate");
        LOGGER.debug("getting the instance of the NamedParameterJdbcTemplate bean");
        NamedParameterJdbcTemplate jdbcTemplate = (NamedParameterJdbcTemplate)ApplicationContextProvider.getApplicationContext().getBean(NamedParameterJdbcTemplate.class);
        HashMap<String, Object> parametroList = new HashMap<String, Object>();
        for (NativeQueryParameter parameter : info.getParameterList()) {
            LOGGER.debug("checking if parameter {} exists in sql", (Object)parameter.getName());
            if (parameter.getValue() == null || !info.getSql().contains(":" + parameter.getName())) continue;
            LOGGER.debug("parameter {} exists in SQL", (Object)parameter.getName());
            LOGGER.debug("parameter {} containing the value {} added to SQL", (Object)parameter.getName(), (Object)parameter.getValue().toString());
            parametroList.put(parameter.getName(), parameter.getValue());
        }
        LOGGER.debug("instantiating a BeanPropertyRowMapper of type {}", (Object)info.getAliasToBean().getName());
        BeanPropertyRowMapper beanPropertyRowMapper = new BeanPropertyRowMapper(info.getAliasToBean());
        if (info.getReturnType().getSimpleName().equals(Void.TYPE.getName())) {
            LOGGER.debug("running update");
            jdbcTemplate.update(info.getSql(), parametroList);
            return null;
        }
        if (info.isSingleResult()) {
            if (info.isJavaObject()) {
                LOGGER.debug("executing the query and returning an object of type {}", (Object)info.getAliasToBean().getName());
                return jdbcTemplate.queryForObject(info.getSql(), parametroList, info.getAliasToBean());
            }
            if (info.returnTypeIsOptional()) {
                LOGGER.debug("executing the query and returning an optional {}", (Object)info.getAliasToBean().getName());
                return this.getOptionalReturn(() -> jdbcTemplate.queryForObject(info.getSql(), parametroList, (RowMapper)beanPropertyRowMapper));
            }
            LOGGER.debug("executing the query and returning an object of type {}", (Object)info.getAliasToBean().getName());
            return jdbcTemplate.queryForObject(info.getSql(), parametroList, (RowMapper)beanPropertyRowMapper);
        }
        LOGGER.debug("executing the query and returning a list of objects of type {}", (Object)info.getAliasToBean().getName());
        if (info.isJavaObject()) {
            return jdbcTemplate.queryForList(info.getSql(), parametroList, info.getAliasToBean());
        }
        return jdbcTemplate.query(info.getSql(), parametroList, (RowMapper)beanPropertyRowMapper);
    }

    private Object executeWithEntityManager(NativeQueryInfo info) {
        NativeQuery query;
        LOGGER.debug("SQL will be executed with EntityManager");
        LOGGER.debug("getting the instance of the EntityManager bean");
        EntityManager entityManager = (EntityManager)ApplicationContextProvider.getApplicationContext().getBean(EntityManager.class);
        Session session = (Session)entityManager.unwrap(Session.class);
        if (info.isEntity()) {
            LOGGER.debug("creating a native query with the entityManager and defining the return class {}", (Object)info.getAliasToBean().getName());
            query = session.createNativeQuery(info.getSql(), info.getAliasToBean());
        } else {
            LOGGER.debug("creating a native query with the entityManager");
            query = session.createNativeQuery(info.getSql());
        }
        this.addParameterJpa(query, info);
        if (info.hasPagination()) {
            LOGGER.debug("setting pagination, first {}, max {}", (Object)info.getFirstResult(), (Object)info.getMaxResult());
            query.setFirstResult(info.getFirstResult());
            query.setMaxResults(info.getMaxResult());
        }
        if (!info.isJavaObject() && !info.isEntity()) {
            if (info.isUseHibernateTypes()) {
                HibernateTypesMapper.map(query, info.getAliasToBean());
            }
            LOGGER.debug("invoking Hibernate ResultTransformer to convert the SQL query to an object of type {}", (Object)info.getAliasToBean().getName());
            query.setResultTransformer(Transformers.aliasToBean(info.getAliasToBean()));
        }
        if (info.getReturnType().getSimpleName().equals(Void.TYPE.getName())) {
            LOGGER.debug("running update");
            query.executeUpdate();
            return null;
        }
        if (info.returnTypeIsOptional()) {
            LOGGER.debug("executes the query returning an optional {}", (Object)info.getAliasToBean().getName());
            return this.getOptionalReturn(() -> ((NativeQuery)query).getSingleResult());
        }
        if (info.isSingleResult()) {
            LOGGER.debug("executes the query by returning an {} object", (Object)info.getAliasToBean().getName());
            return query.getSingleResult();
        }
        List resultList = query.list();
        if (info.isPagination()) {
            LOGGER.debug("creating an object containing the pagination of the data returned in the query");
            return new PageImpl(resultList, info.getPageable(), this.getTotalRecords(info, session).longValue());
        }
        return resultList;
    }

    private Object getOptionalReturn(Supplier<Object> result) {
        try {
            return Optional.ofNullable(result.get());
        }
        catch (NoResultException | EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    private Long getTotalRecords(NativeQueryInfo info, Session session) {
        LOGGER.debug("executing the query to obtain the number of records found to be used in the pagination");
        NativeQuery query = session.createNativeQuery(info.getSqlTotalRecord());
        ((NativeQuery)query.unwrap(NativeQuery.class)).addScalar("totalRecords", StandardBasicTypes.LONG);
        this.addParameterJpa(query, info);
        return (Long)query.getSingleResult();
    }

    private void addParameterJpa(NativeQuery<?> query, NativeQueryInfo info) {
        info.getParameterList().forEach(parameter -> {
            LOGGER.debug("checking if parameter {} exists in sql", (Object)parameter.getName());
            if (parameter.getValue() != null && info.getSql().contains(":" + parameter.getName())) {
                LOGGER.debug("parameter {} exists in SQL", (Object)parameter.getName());
                LOGGER.debug("parameter {} containing the value {} added to SQL", (Object)parameter.getName(), (Object)parameter.getValue().toString());
                query.setParameter(parameter.getName(), parameter.getValue());
            }
        });
    }
}

