/*
 * Decompiled with CFR 0.152.
 */
package io.github.gasparbarancelli;

import io.github.gasparbarancelli.NativeQueryAccessMethod;
import io.github.gasparbarancelli.NativeQueryCache;
import io.github.gasparbarancelli.NativeQueryFieldInfo;
import io.github.gasparbarancelli.NativeQueryOperator;
import io.github.gasparbarancelli.NativeQueryParam;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeQueryParameter
implements Serializable,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeQueryParameter.class);
    private final String name;
    private final Object value;

    public NativeQueryParameter(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    static List<NativeQueryParameter> ofDeclaredMethods(String parentName, Class<?> classe, Object object) {
        ArrayList<NativeQueryParameter> parameterList = new ArrayList<NativeQueryParameter>();
        Map<String, NativeQueryFieldInfo> fieldInfoMap = NativeQueryCache.getFieldInfo(classe);
        List<NativeQueryAccessMethod> accessMethods = NativeQueryCache.getAccessMethods(classe);
        for (NativeQueryAccessMethod accessMethod : accessMethods) {
            NativeQueryParam queryParam;
            Object value = NativeQueryParameter.getValue(object, accessMethod.getMethod());
            NativeQueryFieldInfo fieldInfo = fieldInfoMap.get(accessMethod.getName());
            if (fieldInfo == null) continue;
            NativeQueryParam nativeQueryParam = queryParam = fieldInfo.getParam() != null ? fieldInfo.getParam() : accessMethod.getParam();
            if (queryParam != null) {
                if (queryParam.addChildren()) {
                    String parentNameChildren = parentName + WordUtils.capitalize((String)queryParam.value());
                    parameterList.addAll(NativeQueryParameter.ofDeclaredMethods(parentNameChildren, fieldInfo.getType(), value));
                    continue;
                }
                String paramName = parentName + WordUtils.capitalize((String)queryParam.value());
                if (value instanceof Map) {
                    parameterList.addAll(NativeQueryParameter.ofMap((Map)value, paramName));
                    continue;
                }
                Object paramValue = queryParam.operator().getTransformParam().apply(value);
                parameterList.add(new NativeQueryParameter(paramName, paramValue));
                continue;
            }
            if (value instanceof Map) {
                parameterList.addAll(NativeQueryParameter.ofMap((Map)value, parentName + accessMethod.getName()));
                continue;
            }
            Object paramValue = NativeQueryOperator.DEFAULT.getTransformParam().apply(value);
            parameterList.add(new NativeQueryParameter(parentName + accessMethod.getName(), paramValue));
        }
        return parameterList;
    }

    private static Object getValue(Object object, Method method) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    static List<NativeQueryParameter> ofMap(Map map, String name) {
        ArrayList<NativeQueryParameter> parameterList = new ArrayList<NativeQueryParameter>();
        parameterList.add(new NativeQueryParameter(name, map.keySet()));
        map.forEach((k, v) -> parameterList.add(new NativeQueryParameter(k.toString(), v)));
        return parameterList;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "NativeQueryParameter{name='" + this.name + "', value=" + this.value + "}";
    }
}

