/*
 * Decompiled with CFR 0.152.
 */
package io.github.gasparbarancelli;

import io.github.gasparbarancelli.NativeQuery;
import io.github.gasparbarancelli.NativeQueryCache;
import io.github.gasparbarancelli.NativeQueryInfo;
import io.github.gasparbarancelli.NativeQueryMethodInterceptor;
import io.github.gasparbarancelli.NativeQueryMethodInterceptorImpl;
import io.github.gasparbarancelli.NativeQueryProxyFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;

public class NativeQueryProxyFactoryImpl
implements NativeQueryProxyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeQueryProxyFactoryImpl.class);
    private final NativeQueryMethodInterceptor nativeQueryMethodInterceptor = new NativeQueryMethodInterceptorImpl();
    private static final Map<CacheKey, NativeQueryInfo> cache = new HashMap<CacheKey, NativeQueryInfo>();

    @Override
    public Object create(Class<? extends NativeQuery> classe) {
        LOGGER.debug("creating an {} interface proxy", (Object)classe.getName());
        ProxyFactory proxy = new ProxyFactory();
        proxy.setTarget(Mockito.mock(classe));
        proxy.setInterfaces(new Class[]{classe, NativeQuery.class});
        proxy.addAdvice((Advice)((MethodInterceptor)invocation -> {
            if ("toString".equals(invocation.getMethod().getName())) {
                return "NativeQuery Implementation";
            }
            LOGGER.debug("intercepting the call of method {} of class {}", (Object)invocation.getMethod().getName(), (Object)classe.getName());
            NativeQueryInfo info = NativeQueryCache.get(classe, invocation);
            return this.nativeQueryMethodInterceptor.executeQuery(info);
        }));
        return proxy.getProxy(classe.getClassLoader());
    }

    private static class CacheKey {
        String className;
        String methodName;

        public CacheKey(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.className, cacheKey.className) && Objects.equals(this.methodName, cacheKey.methodName);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.methodName);
        }
    }
}

