/*
 * Decompiled with CFR 0.152.
 */
package io.github.gasparbarancelli;

import io.github.gasparbarancelli.NativeQuery;
import io.github.gasparbarancelli.NativeQueryBeanDefinition;
import io.github.gasparbarancelli.NativeQueryProxyFactory;
import io.github.gasparbarancelli.NativeQueryProxyFactoryImpl;
import io.github.gasparbarancelli.NativeQueryRegistry;
import java.beans.Introspector;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class NativeQueryRegistryImpl
implements NativeQueryRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeQueryRegistryImpl.class);
    private final NativeQueryProxyFactory nativeQueryProxyFactory = new NativeQueryProxyFactoryImpl();
    private final BeanDefinitionRegistry registry;

    public NativeQueryRegistryImpl(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void registry(Set<Class<? extends NativeQuery>> nativeQueryList) {
        for (Class<? extends NativeQuery> classe : nativeQueryList) {
            Object source = this.nativeQueryProxyFactory.create(classe);
            AbstractBeanDefinition beanDefinition = NativeQueryBeanDefinition.of(classe, source);
            String beanName = Introspector.decapitalize(classe.getSimpleName());
            LOGGER.debug("registering the bean {}", (Object)beanName);
            this.registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }
}

