/*
 * Decompiled with CFR 0.152.
 */
package org.gciatto.kt.math;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gciatto.kt.math.RoundingMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/gciatto/kt/math/MathContext;", "", "()V", "precision", "", "(I)V", "roundingMode", "Lorg/gciatto/kt/math/RoundingMode;", "(Lorg/gciatto/kt/math/RoundingMode;)V", "(ILorg/gciatto/kt/math/RoundingMode;)V", "getPrecision", "()I", "getRoundingMode", "()Lorg/gciatto/kt/math/RoundingMode;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "kt-math"})
public final class MathContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int precision;
    @NotNull
    private final RoundingMode roundingMode;
    @JvmField
    @NotNull
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    @JvmField
    @NotNull
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    @JvmField
    @NotNull
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    @JvmField
    @NotNull
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);

    public MathContext(int precision, @NotNull RoundingMode roundingMode2) {
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode2), (String)"roundingMode");
        this.precision = precision;
        this.roundingMode = roundingMode2;
        boolean bl = this.precision >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final int getPrecision() {
        return this.precision;
    }

    @NotNull
    public final RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public MathContext() {
        this(9, RoundingMode.HALF_UP);
    }

    public MathContext(int precision) {
        this(precision, RoundingMode.HALF_UP);
    }

    public MathContext(@NotNull RoundingMode roundingMode2) {
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode2), (String)"roundingMode");
        this(9, roundingMode2);
    }

    @NotNull
    public String toString() {
        return "precision=" + this.precision + " roundingMode=" + (Object)((Object)this.roundingMode);
    }

    public final int component1() {
        return this.precision;
    }

    @NotNull
    public final RoundingMode component2() {
        return this.roundingMode;
    }

    @NotNull
    public final MathContext copy(int precision, @NotNull RoundingMode roundingMode2) {
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode2), (String)"roundingMode");
        return new MathContext(precision, roundingMode2);
    }

    public static /* synthetic */ MathContext copy$default(MathContext mathContext, int n, RoundingMode roundingMode2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mathContext.precision;
        }
        if ((n2 & 2) != 0) {
            roundingMode2 = mathContext.roundingMode;
        }
        return mathContext.copy(n, roundingMode2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.precision);
        result = result * 31 + this.roundingMode.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MathContext)) {
            return false;
        }
        MathContext mathContext = (MathContext)other;
        if (this.precision != mathContext.precision) {
            return false;
        }
        return this.roundingMode == mathContext.roundingMode;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u0016\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u00a8\u0006\f"}, d2={"Lorg/gciatto/kt/math/MathContext$Companion;", "", "()V", "DECIMAL128", "Lorg/gciatto/kt/math/MathContext;", "getDECIMAL128$annotations", "DECIMAL32", "getDECIMAL32$annotations", "DECIMAL64", "getDECIMAL64$annotations", "UNLIMITED", "getUNLIMITED$annotations", "kt-math"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getUNLIMITED$annotations() {
        }

        public static /* synthetic */ void getDECIMAL32$annotations() {
        }

        public static /* synthetic */ void getDECIMAL64$annotations() {
        }

        public static /* synthetic */ void getDECIMAL128$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

